/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.services.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.quadcom.datapack.loaders.impl.HardPvpGroupsLoader;
import ru.quadcom.datapack.loaders.impl.HardPvpUnitsLoader;
import ru.quadcom.datapack.loaders.impl.NPCGenerationLoader;
import ru.quadcom.datapack.loaders.impl.NpcLoader;
import ru.quadcom.datapack.services.INPCPack;
import ru.quadcom.datapack.templates.contract.ContractEnemyType;
import ru.quadcom.datapack.templates.contract.ContractNpcDifficulty;
import ru.quadcom.datapack.templates.npc.HardPvpGroupTemplate;
import ru.quadcom.datapack.templates.npc.HardPvpUnitTemplate;
import ru.quadcom.datapack.templates.npc.NPCGeneration;
import ru.quadcom.datapack.templates.npc.NpcTemplate;

public class NPCPack
implements INPCPack {
    private final String prefix = "";
    private Map<ContractNpcDifficulty, NPCGeneration> npcGeneration;
    private Map<Integer, NpcTemplate> npc;
    private Map<String, List<NpcTemplate>> npcsByMissionId;
    private Map<ContractEnemyType, List<HardPvpGroupTemplate>> hardPvpGroupsByNpcType;
    private Map<String, List<HardPvpUnitTemplate>> hardPvpUnitsByGroupId;

    NPCPack(String resourceUrl) {
        this.npcGeneration = new NPCGenerationLoader(resourceUrl, "").load("npc_generation.json");
        this.npc = new NpcLoader(resourceUrl, "").load("npc.json");
        Object hardPvpGroupByDescriptor = new HardPvpGroupsLoader(resourceUrl, "").load("hardpvp_groups.json");
        Object hardPvpUnitsByDescriptor = new HardPvpUnitsLoader(resourceUrl, "").load("hardpvp_units.json");
        this.npcsByMissionId = new HashMap<String, List<NpcTemplate>>();
        this.hardPvpGroupsByNpcType = new HashMap<ContractEnemyType, List<HardPvpGroupTemplate>>();
        for (Object template : hardPvpGroupByDescriptor.values()) {
            if (!this.hardPvpGroupsByNpcType.containsKey((Object)((HardPvpGroupTemplate)template).getUnitsType())) {
                this.hardPvpGroupsByNpcType.put(((HardPvpGroupTemplate)template).getUnitsType(), new ArrayList());
            }
            this.hardPvpGroupsByNpcType.get((Object)((HardPvpGroupTemplate)template).getUnitsType()).add((HardPvpGroupTemplate)template);
        }
        this.hardPvpUnitsByGroupId = new HashMap<String, List<HardPvpUnitTemplate>>();
        for (Object template : hardPvpUnitsByDescriptor.values()) {
            if (!this.hardPvpUnitsByGroupId.containsKey(((HardPvpUnitTemplate)template).getGroupId())) {
                this.hardPvpUnitsByGroupId.put(((HardPvpUnitTemplate)template).getGroupId(), new ArrayList());
            }
            this.hardPvpUnitsByGroupId.get(((HardPvpUnitTemplate)template).getGroupId()).add((HardPvpUnitTemplate)template);
        }
    }

    @Override
    public NPCGeneration getGeneration(ContractNpcDifficulty difficulty) {
        return this.npcGeneration.get((Object)difficulty);
    }

    @Override
    public NpcTemplate getNpcTemplate(int id) {
        return this.npc.get(id);
    }

    @Override
    public List<NpcTemplate> getNpcTemplatesByMissionId(String missionId) {
        return this.npcsByMissionId.get(missionId);
    }

    @Override
    public List<HardPvpGroupTemplate> getHardPvpGroupsByType(ContractEnemyType npcType) {
        return this.hardPvpGroupsByNpcType.get((Object)npcType);
    }

    @Override
    public List<HardPvpUnitTemplate> getHardPvpUnitsForGroup(String groupId) {
        return this.hardPvpUnitsByGroupId.get(groupId);
    }
}

