/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.domains.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import one.util.streamex.StreamEx;
import ru.quadcom.datapack.domains.BaseVariable;
import ru.quadcom.datapack.domains.item.Item;
import ru.quadcom.datapack.domains.item.ItemTemplatePropertyName;
import ru.quadcom.datapack.services.IDataPack;
import ru.quadcom.exceptions.WarningException;

public class ItemUtils {
    public static long calculateSellPriceOfItemList(List<Item> itemList, IDataPack dataPack, int errorCode) {
        ArrayList itemsPlusAttached = Lists.newArrayList();
        for (Item item2 : itemList) {
            itemsPlusAttached.add(item2);
            itemsPlusAttached.addAll(item2.getAttachedItems().values());
        }
        return StreamEx.of((Collection)itemsPlusAttached).map(item -> dataPack.getItemPack().getItemTemplateOptional(item.getItemTemplateId()).orElseThrow(() -> new WarningException("Item template with id " + item.getItemTemplateId() + " by item with id " + item.getId() + " not found in datapack!", errorCode))).mapToLong(template -> {
            int basePrice = template.getIntItemTemplateProperty(ItemTemplatePropertyName.price);
            return (long)((double)basePrice * BaseVariable.SALE_PRICE_MODIFIER.getDouble());
        }).sum();
    }
}

