/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.services.impl;

import ru.quadcom.datapack.domains.BaseVariable;
import ru.quadcom.datapack.services.IAchievementPack;
import ru.quadcom.datapack.services.ICommonPack;
import ru.quadcom.datapack.services.IContractPack;
import ru.quadcom.datapack.services.IDataPack;
import ru.quadcom.datapack.services.IItemPack;
import ru.quadcom.datapack.services.INPCPack;
import ru.quadcom.datapack.services.IOperatorPack;
import ru.quadcom.datapack.services.IShopPack;
import ru.quadcom.datapack.services.impl.AchievementPack;
import ru.quadcom.datapack.services.impl.CommonPack;
import ru.quadcom.datapack.services.impl.ContractPack;
import ru.quadcom.datapack.services.impl.ItemPack;
import ru.quadcom.datapack.services.impl.NPCPack;
import ru.quadcom.datapack.services.impl.OperatorPack;
import ru.quadcom.datapack.services.impl.ShopPack;
import ru.quadcom.datapack.templates.common.BaseConstantsTemplate;

public abstract class DataPack
implements IDataPack {
    private IOperatorPack operatorPack;
    private IItemPack itemPack;
    private ICommonPack commonPack;
    private IAchievementPack achievementPack;
    private IShopPack shopPack;
    private IContractPack contractPack;
    private INPCPack npcPack;
    private final String resourceUrl;

    public DataPack(String resourceUrl) {
        this.resourceUrl = resourceUrl;
        this.reload();
    }

    @Override
    public INPCPack getNpcPack() {
        return this.npcPack;
    }

    @Override
    public IOperatorPack getOperatorPack() {
        return this.operatorPack;
    }

    @Override
    public IItemPack getItemPack() {
        return this.itemPack;
    }

    @Override
    public ICommonPack getCommonPack() {
        return this.commonPack;
    }

    @Override
    public IAchievementPack getAchievementPack() {
        return this.achievementPack;
    }

    @Override
    public IShopPack getShopPack() {
        return this.shopPack;
    }

    @Override
    public IContractPack getContractPack() {
        return this.contractPack;
    }

    @Override
    public synchronized void reload() {
        this.operatorPack = new OperatorPack(this.resourceUrl);
        this.itemPack = new ItemPack(this.resourceUrl);
        this.commonPack = new CommonPack(this.resourceUrl);
        this.achievementPack = new AchievementPack(this.resourceUrl);
        this.shopPack = new ShopPack(this.resourceUrl);
        this.contractPack = new ContractPack(this.resourceUrl);
        this.npcPack = new NPCPack(this.resourceUrl);
        for (BaseVariable baseVariable : BaseVariable.values()) {
            BaseConstantsTemplate template = this.getCommonPack().getBaseConstant(baseVariable.getDescriptor());
            if (template == null) {
                baseVariable.set(baseVariable.getDefaultValue());
                continue;
            }
            baseVariable.set(template.getValue());
        }
    }
}

