/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.domains;

import ru.quadcom.datapack.domains.Calculable;

public enum BaseVariable implements Calculable
{
    UNIT_TURN_DURATION_SECONDS("unit_turn_duration_seconds", 30.0, false, false),
    GRENADE_DESTROY_RADIUS("grenade_destroy_radius", 1.0, true, false),
    MIN_TURN_DURATION_SECONDS("min_turn_duration_seconds", 40.0, true, true),
    FASTCHESS_BASE_PLAYER_TIME("fastchess_base_player_time", 300.0, false, false),
    FASTCHESS_ADDITIONAL_TIME("fastchess_additional_time", 60.0, false, false),
    BASE_CRIT_DAMAGE("base_crit_damage", 150.0, true, true),
    ARMOR_DETERRENCE("armor_deterrence", 70.0, true, true),
    ARMOR_DESTRUCTION("armor_destruction", 50.0, true, true),
    SHELTER_HALF_EFFECT("shelter_half_effect", 15.0, true, true),
    SHELTER_FULL_EFFECT("shelter_full_effect", 30.0, true, true),
    HIGHGROUND_EFFECT("highground_effect", 10.0, true, true),
    HIGHGROUND_VISIBILITY_BONUS("highground_visibility_bonus", 5.0, true, false),
    HIGHGROUND_DETECTION_BONUS("highground_detection_bonus", 5.0, true, false),
    MAX_DURABILITY_HIT_PENALTY("max_durability_hit_penalty", 47.0, false, true),
    FIRST_ACTION_MOVE_BONUS("first_action_move_bonus", 50.0, false, true),
    HIT_CURV("hit_curv", 1.0, false, true),
    HIT_SMOOTH_FACTOR("hit_smooth_factor", 1.0, false, false),
    OVERWATCH_EFFECT_HIT_PENALTY("overwatch_effect_hit_penalty", 15.0, true, true),
    MC_HP("mc_hp", 1.0, true, true),
    MC_SPEED("mc_speed", 1.0, true, true),
    MC_HIT_CHANCE("mc_hit_chance", 1.0, true, true),
    MC_VISIBILITY_RADIUS("mc_visibility_radius", 1.0, true, true),
    MC_DETECTION_RADIUS("mc_detection_radius", 1.0, true, true),
    MC_STEALTH_RADIUS("mc_stealth_radius", 1.0, true, true),
    MC_HIT_CHANCE_REDUCE("mc_hit_chance_reduce", 1.0, true, true),
    MC_CRITICAL_CHANCE("mc_critical_chance", 1.0, true, true),
    MC_FORTITUDE("mc_fortitude", 1.0, true, true),
    MC_DODGE("mc_dodge", 1.0, true, true),
    MC_THROW_RANGE("mc_throw_range", 1.0, true, true),
    MC_ARMOR_BONUS("mc_armor_bonus", 1.0, true, true),
    BASE_HP("base_hp", 2.0, true, false),
    BASE_SPEED("base_speed", 8.0, true, false),
    BASE_VISIBILITY_RADIUS("base_visibility_radius", 28.0, true, false),
    BASE_DETECTION_RADIUS("base_detection_radius", 20.0, true, false),
    BASE_STEALTH_RADIUS("base_stealth_radius", 0.0, true, false),
    BASE_HIT_CHANCE_REDUCE("base_hit_chance_reduce", 0.0, true, false),
    BASE_CRITICAL_CHANCE("base_critical_chance", 0.0, true, false),
    BASE_FORTITUDE("base_fortitude", 0.0, true, false),
    BASE_DODGE("base_dodge", 0.0, true, false),
    BASE_THROW_RANGE("base_throw_range", 8.0, true, false),
    BASE_ARMOR_BONUS("base_armor_bonus", 0.0, true, false),
    SM_HP("sm_hp", 0.2, true, true),
    SM_SPEED("sm_speed", 1.0, true, true),
    SM_HIT_CHANCE("sm_hit_chance", 1.0, true, true),
    SM_VISIBILITY_RADIUS("sm_visibility_radius", 1.0, true, true),
    SM_DETECTION_RADIUS("sm_detection_radius", 0.125, true, true),
    SM_STEALTH_RADIUS("sm_stealth_radius", 1.0, true, true),
    SM_HIT_CHANCE_BONUS("sm_hit_chance_bonus", 0.166, true, true),
    SM_CRITICAL_CHANCE("sm_critical_chance", 0.25, true, true),
    SM_FORTITUDE("sm_fortitude", 0.2, true, true),
    SM_DODGE("sm_dodge", 0.166, true, true),
    SM_THROW_RANGE("sm_throw_range", 0.14, true, true),
    SM_ARMOR_BONUS("sm_armor_bonus", 0.666, true, true),
    SM_SHELTER("sm_shelter", 0.125, true, true),
    WEAPON_DURABILITY_DECREASE("weapon_durability_decrease", 15.0, true, false),
    ARMOR_DURABILITY_DECREASE("armor_durability_decrease", 5.0, true, false),
    HEAL_VALUE("heal_value", 3.0, true, false),
    HEAL_PRICE("heal_price", 2.0, true, false),
    HEAL_TIME("heal_time", 900000.0, true, false),
    REPAIR_MAX_VALUE("repair_max_value", 0.5, true, true),
    REPAIR_PRICE_VALUE("repair_price_value", 1.0, true, false),
    COVER_HIT_PROBABILITY("cover_hit_probability", 50.0, true, true),
    SLOT_COUNT("slot_count", 0.0, true, false),
    MC_DISORIENT_RESIST("mc_disorient_resist", 1.0, false, true),
    MC_PANIC_RESIST("mc_panic_resist", 1.0, false, true),
    MC_BLEED_RESIST("mc_bleed_resist", 1.0, false, true),
    MC_POISON_RESIST("mc_poison_resist", 1.0, false, true),
    MC_FIRE_RESIST("mc_fire_resist", 1.0, false, true),
    SM_DISORIENT_RESIST("sm_disorient_resist", 0.333, false, true),
    SM_PANIC_RESIST("sm_panic_resist", 0.333, false, true),
    SM_BLEED_RESIST("sm_bleed_resist", 0.333, false, true),
    SM_POISON_RESIST("sm_poison_resist", 0.333, false, true),
    SM_FIRE_RESIST("sm_fire_resist", 0.333, false, true),
    CRITICAL_STATE_PROBABILITY("critical_state_probability", 50.0, false, true),
    SALE_PRICE_MODIFIER("sale_price_modifier", 0.1, false, true),
    DISCONNECT_DURABILITY_PENALTY("disconnect_durability_penalty", 0.4, false, true),
    MINIMAL_DETECTION_RADIUS("minimal_detection_radius", 4.0, true, false),
    MINIMAL_MOBILITY("minimal_mobility", 2.0, true, false),
    ALTERNATIVE_CLASS_GENERATION_FOR_ELITE("alternative_class_generation_for_elite", 0.0, true, false);

    private double defaultValue;
    private volatile double value;
    private String descriptor;
    private boolean canZero;
    private boolean real;

    private BaseVariable(String descriptor, double defaultValue, boolean canZero, boolean real) {
        this.descriptor = descriptor;
        this.defaultValue = defaultValue;
        this.value = defaultValue;
        this.canZero = canZero;
        this.real = real;
    }

    private boolean isReal() {
        return this.real;
    }

    private boolean isCanZero() {
        return this.canZero;
    }

    public double getDefaultValue() {
        return this.defaultValue;
    }

    public void set(double value) {
        if (!this.isReal()) {
            value = (int)value;
        }
        if (value == 0.0 && !this.isCanZero()) {
            value = this.isReal() ? 0.01 : 1.0;
        }
        this.value = value;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public double applyMultiple(double value) {
        return this.value * value;
    }

    @Override
    public double applyAdditive(double value) {
        return this.value + value;
    }

    @Override
    public double applyDivision(double value) {
        return value / this.value;
    }

    @Override
    public int getInt() {
        return (int)this.value;
    }

    @Override
    public int applyMultiple(int value) {
        return (int)(this.value * (double)value);
    }

    @Override
    public int applyAdditive(int value) {
        return (int)this.value + value;
    }

    @Override
    public int applyDivision(int value) {
        return (int)((double)value / this.value);
    }
}

