/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.services.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import one.util.streamex.StreamEx;
import ru.quadcom.datapack.common.EnumUtil;
import ru.quadcom.datapack.domains.operator.DefaultEquipment;
import ru.quadcom.datapack.domains.operator.OperatorRarity;
import ru.quadcom.datapack.domains.operator.StartEquipment;
import ru.quadcom.datapack.domains.operator.UnitTraitGroupType;
import ru.quadcom.datapack.domains.operator.UnitTraitType;
import ru.quadcom.datapack.loaders.impl.AvatarLoader;
import ru.quadcom.datapack.loaders.impl.BodyKitSetLoader;
import ru.quadcom.datapack.loaders.impl.ClassDecorationLoader;
import ru.quadcom.datapack.loaders.impl.ClassesLoader;
import ru.quadcom.datapack.loaders.impl.DefaultEquipmentLoader;
import ru.quadcom.datapack.loaders.impl.FirstUnitsGenerationLoader;
import ru.quadcom.datapack.loaders.impl.FractionsLoader;
import ru.quadcom.datapack.loaders.impl.GendersLoader;
import ru.quadcom.datapack.loaders.impl.HeadKitLoader;
import ru.quadcom.datapack.loaders.impl.NamesLoader;
import ru.quadcom.datapack.loaders.impl.NationalityLoader;
import ru.quadcom.datapack.loaders.impl.OperatorDecorationLoader;
import ru.quadcom.datapack.loaders.impl.OperatorPrefabsLoader;
import ru.quadcom.datapack.loaders.impl.RacesLoader;
import ru.quadcom.datapack.loaders.impl.RanksLoader;
import ru.quadcom.datapack.loaders.impl.RaritiesLoader;
import ru.quadcom.datapack.loaders.impl.SexClassLoader;
import ru.quadcom.datapack.loaders.impl.SpikeDistributionLoader;
import ru.quadcom.datapack.loaders.impl.StartEquipmentLoader;
import ru.quadcom.datapack.loaders.impl.UnitTraitsLoader;
import ru.quadcom.datapack.loaders.impl.VoiceLoader;
import ru.quadcom.datapack.services.IOperatorPack;
import ru.quadcom.datapack.templates.operator.AvatarTemplate;
import ru.quadcom.datapack.templates.operator.BodyKitSet;
import ru.quadcom.datapack.templates.operator.ClassDecoration;
import ru.quadcom.datapack.templates.operator.ClassTemplate;
import ru.quadcom.datapack.templates.operator.FirstUnitsGenerationTemplate;
import ru.quadcom.datapack.templates.operator.FractionTemplate;
import ru.quadcom.datapack.templates.operator.GenderTemplate;
import ru.quadcom.datapack.templates.operator.HeadKit;
import ru.quadcom.datapack.templates.operator.NameTemplate;
import ru.quadcom.datapack.templates.operator.NationalityTemplate;
import ru.quadcom.datapack.templates.operator.OperatorDecorationTemplate;
import ru.quadcom.datapack.templates.operator.OperatorPrefabsTemplate;
import ru.quadcom.datapack.templates.operator.RaceTemplate;
import ru.quadcom.datapack.templates.operator.RankTemplate;
import ru.quadcom.datapack.templates.operator.RarityTemplate;
import ru.quadcom.datapack.templates.operator.Sex;
import ru.quadcom.datapack.templates.operator.SexClassTemplate;
import ru.quadcom.datapack.templates.operator.SpikeDistributionTemplate;
import ru.quadcom.datapack.templates.operator.UnitTraitTemplate;
import ru.quadcom.datapack.templates.operator.VoiceTemplate;
import ru.quadcom.exceptions.ErrorException;

public class OperatorPack
implements IOperatorPack {
    private static final Random random = new Random();
    private final Map<String, AvatarTemplate> avatars;
    private final Map<String, AvatarTemplate> availableAvatars;
    private final Map<Integer, ClassTemplate> classes;
    private final NavigableMap<Double, ClassTemplate> randomBaseClasses;
    private final Map<Integer, NavigableMap<Double, ClassTemplate>> randomNotBaseClasses;
    private final Map<Integer, RankTemplate> ranks;
    private final NavigableMap<Long, RankTemplate> experienceRanks;
    private final Map<Integer, FractionTemplate> fractions;
    private final List<FractionTemplate> fractionsForRandomNpc;
    private final Map<Integer, NationalityTemplate> nationalities;
    private final Map<Integer, GenderTemplate> genders;
    private final Map<Integer, RaceTemplate> races;
    private final Map<Integer, RarityTemplate> rarities;
    private final Map<OperatorRarity, RarityTemplate> raritiesByName;
    private final NavigableMap<Double, RarityTemplate> randomRarities;
    private final Map<String, SpikeDistributionTemplate> spikeDistributions;
    private final Map<Integer, DefaultEquipment> defaultEquipments;
    private final Map<Integer, Map<Integer, Map<Integer, StartEquipment>>> startEquipments;
    private final Map<Integer, NavigableMap<Double, OperatorPrefabsTemplate>> operatorPrefabs;
    private final Map<Integer, List<FirstUnitsGenerationTemplate>> firstUnitsGenerations;
    private final Map<Integer, Map<Integer, List<NameTemplate>>> names;
    private final Map<Integer, NavigableMap<Double, SexClassTemplate>> sexClasses;
    private final Map<Integer, OperatorDecorationTemplate> operatorDecorations;
    private final Map<String, OperatorDecorationTemplate> operatorDecorationsByGUID;
    private final Map<Integer, List<ClassDecoration>> classDecorations;
    private final Map<UnitTraitType, UnitTraitTemplate> unitTraits;
    private final Map<UnitTraitGroupType, NavigableMap<Double, UnitTraitTemplate>> unitTraitsByChance;
    private final Map<Integer, BodyKitSet> bodyKitSets;
    private final BodyKitSet[] allBodyKitSetsArray;
    private final BodyKitSet[] playerBodyKitSetsArray;
    private final Map<Integer, HeadKit> headKits;
    private final HeadKit[] headKitArray;
    private final Map<Integer, VoiceTemplate> voices;
    private final String prefix = "";

    OperatorPack(String resourceUrl) {
        this.avatars = new AvatarLoader(resourceUrl, "").load("avatars.json");
        this.availableAvatars = ((StreamEx)StreamEx.of(this.avatars.entrySet()).filter(entry -> ((AvatarTemplate)entry.getValue()).isAvailable())).toMap(Map.Entry::getKey, Map.Entry::getValue);
        this.classes = new ClassesLoader(resourceUrl, "").load("classes.json");
        this.randomBaseClasses = Maps.newTreeMap();
        this.randomNotBaseClasses = Maps.newHashMap();
        for (ClassTemplate template2 : this.classes.values()) {
            if (!(template2.getChance() > 0.0)) continue;
            NavigableMap navmap = template2.isBase() ? this.randomBaseClasses : this.randomNotBaseClasses.computeIfAbsent(template2.getRarity(), q -> Maps.newTreeMap());
            double max = (navmap.isEmpty() ? 0.0 : (Double)navmap.lastKey()) + template2.getChance();
            navmap.put(max, template2);
        }
        this.ranks = new RanksLoader(resourceUrl, "").load("ranks.json");
        this.experienceRanks = Maps.newTreeMap();
        StreamEx.of(this.ranks.values()).forEach(template -> this.experienceRanks.put(template.getExperience(), (RankTemplate)template));
        this.fractions = new FractionsLoader(resourceUrl, "").load("fractions.json");
        this.fractionsForRandomNpc = new ArrayList<FractionTemplate>();
        for (FractionTemplate fractionTemplate : this.fractions.values()) {
            if (!fractionTemplate.isAvailableForRandomNpc()) continue;
            this.fractionsForRandomNpc.add(fractionTemplate);
        }
        this.genders = new GendersLoader(resourceUrl, "").load("genders.json");
        this.races = new RacesLoader(resourceUrl, "").load("races.json");
        this.rarities = new RaritiesLoader(resourceUrl, "").load("rarities.json");
        this.raritiesByName = StreamEx.of(this.rarities.values()).toMap(template -> EnumUtil.lookup(OperatorRarity.class, template.getDescriptor()), Function.identity());
        this.randomRarities = Maps.newTreeMap();
        StreamEx.of(this.rarities.values()).forEach(template -> {
            double max = (this.randomRarities.isEmpty() ? 0.0 : (Double)this.randomRarities.lastKey()) + template.getChance();
            this.randomRarities.put(max, (RarityTemplate)template);
        });
        this.spikeDistributions = new SpikeDistributionLoader(resourceUrl, "").load("spike_distributions.json");
        this.defaultEquipments = new DefaultEquipmentLoader(resourceUrl, "").load("default_equipments.json");
        this.startEquipments = new StartEquipmentLoader(resourceUrl, "").load("start_equipments.json");
        this.nationalities = new NationalityLoader(resourceUrl, "").load("nationalities.json");
        this.operatorPrefabs = new OperatorPrefabsLoader(resourceUrl, "").load("operator_prefabs.json");
        this.firstUnitsGenerations = new FirstUnitsGenerationLoader(resourceUrl, "").load("first_units_generations.json");
        this.names = new NamesLoader(resourceUrl, "").load("names.json");
        this.sexClasses = new SexClassLoader(resourceUrl, "").load("sex_class.json");
        this.operatorDecorations = new OperatorDecorationLoader(resourceUrl, "").load("operator_decorations.json");
        this.operatorDecorationsByGUID = StreamEx.of(this.operatorDecorations.values()).toMap(template -> template.getUnitSkinPart().getGuid(), template -> template);
        this.classDecorations = new ClassDecorationLoader(resourceUrl, "").load("class_decorations.json");
        this.unitTraits = new UnitTraitsLoader(resourceUrl, "").load("units_traits.json");
        this.unitTraitsByChance = Maps.newHashMap();
        for (UnitTraitTemplate unitTraitTemplate : this.unitTraits.values()) {
            UnitTraitGroupType unitTraitGroupType = unitTraitTemplate.getUnitTraitGroupType();
            NavigableMap<Double, UnitTraitTemplate> map = this.unitTraitsByChance.getOrDefault((Object)unitTraitGroupType, Maps.newTreeMap());
            this.unitTraitsByChance.putIfAbsent(unitTraitGroupType, map);
            double max = (map.isEmpty() ? 0.0 : (Double)map.lastKey()) + unitTraitTemplate.getChance();
            map.put(max, unitTraitTemplate);
        }
        this.bodyKitSets = new BodyKitSetLoader(resourceUrl, "").load("body_kit_sets.json");
        this.allBodyKitSetsArray = this.bodyKitSets.values().toArray(new BodyKitSet[0]);
        this.playerBodyKitSetsArray = (BodyKitSet[])this.bodyKitSets.values().stream().filter(BodyKitSet::isAvailableToPlayer).toArray(BodyKitSet[]::new);
        this.headKits = new HeadKitLoader(resourceUrl, "").load("head_kits.json");
        this.headKitArray = (HeadKit[])this.headKits.values().stream().filter(headKit -> headKit.getPriority() > 0).toArray(HeadKit[]::new);
        this.voices = new VoiceLoader(resourceUrl, "").load("voices.json");
    }

    @Override
    public VoiceTemplate getVoice(int id) {
        if (!this.voices.containsKey(id)) {
            throw new ErrorException("not found voice with id " + id);
        }
        return this.voices.get(id);
    }

    @Override
    public VoiceTemplate getVoiceForPlayer(Sex sex) {
        return (VoiceTemplate)((StreamEx)((StreamEx)StreamEx.of(this.voices.values()).filter(VoiceTemplate::isPlayer)).filter(template -> template.getSex() == sex)).findAny().orElseThrow(() -> new ErrorException("not found voice for sex " + (Object)((Object)sex)));
    }

    @Override
    public Optional<StartEquipment> getStartEquipment(int nationalityId, int rarityId, int classId) {
        Map<Integer, StartEquipment> cmap;
        Map<Integer, Map<Integer, StartEquipment>> rcmap = this.startEquipments.get(nationalityId);
        if (rcmap != null && (cmap = rcmap.get(rarityId)) != null) {
            StartEquipment se = cmap.get(classId);
            return Optional.ofNullable(se);
        }
        return Optional.empty();
    }

    @Override
    public Map<Integer, BodyKitSet> getBodyKitSets() {
        return this.bodyKitSets;
    }

    @Override
    public BodyKitSet getBodyKitSet(int id) {
        return this.bodyKitSets.get(id);
    }

    @Override
    public BodyKitSet getRandomBodyKitSet() {
        return this.allBodyKitSetsArray[random.nextInt(this.allBodyKitSetsArray.length)];
    }

    @Override
    public BodyKitSet getRandomBodyKitSetForPlayer() {
        return this.playerBodyKitSetsArray[random.nextInt(this.playerBodyKitSetsArray.length)];
    }

    @Override
    public Map<Integer, HeadKit> getHeadKits() {
        return this.headKits;
    }

    @Override
    public HeadKit getHeadKit(int id) {
        return this.headKits.get(id);
    }

    @Override
    public HeadKit getRandomHeadKit() {
        return this.headKitArray[random.nextInt(this.headKitArray.length)];
    }

    @Override
    public UnitTraitTemplate getUnitTraitByType(UnitTraitType type) {
        return this.unitTraits.get((Object)type);
    }

    @Override
    public UnitTraitTemplate getRandomUnitTraitByGroupType(UnitTraitGroupType type) {
        NavigableMap<Double, UnitTraitTemplate> map = this.unitTraitsByChance.get((Object)type);
        return Optional.ofNullable(map.ceilingEntry(Math.random() * (Double)map.lastKey())).map(Map.Entry::getValue).orElse(null);
    }

    private <T> T getNextRandom(List<T> list) {
        return list.get(random.nextInt(list.size()));
    }

    @Override
    public DefaultEquipment getDefaultEquipment(ClassTemplate classTemplate) {
        return this.defaultEquipments.get(classTemplate.getId());
    }

    @Override
    public List<AvatarTemplate> getAvatars() {
        return StreamEx.of(this.avatars.values()).toList();
    }

    @Override
    public AvatarTemplate getAvatar(String name) {
        return this.avatars.get(name);
    }

    @Override
    public AvatarTemplate getNextAvatar(RaceTemplate race, GenderTemplate gender) {
        List avatars = ((StreamEx)StreamEx.of(this.availableAvatars.values()).filter(avatar -> avatar.getSex() == gender.getId() && avatar.getRace() == race.getId())).toList();
        Collections.shuffle(avatars);
        return (AvatarTemplate)StreamEx.of((Collection)avatars).findFirst().orElseThrow(() -> new ErrorException("not found avatar for race=" + race.getDescriptor() + " gender=" + gender.getDescriptor()));
    }

    @Override
    public List<ClassTemplate> getClasses() {
        return StreamEx.of(this.classes.values()).toList();
    }

    @Override
    public ClassTemplate getClass(int id) {
        return this.classes.get(id);
    }

    @Override
    public ClassTemplate getNextBaseClass() {
        double max = (Double)this.randomBaseClasses.lastKey();
        return this.randomBaseClasses.ceilingEntry(max * random.nextDouble()).getValue();
    }

    @Override
    public ClassTemplate getNextNotBaseClass(RarityTemplate rarityTemplate) {
        NavigableMap<Double, ClassTemplate> navmap = this.randomNotBaseClasses.get(rarityTemplate.getId());
        if (navmap == null || navmap.isEmpty()) {
            return null;
        }
        double max = (Double)navmap.lastKey();
        return navmap.ceilingEntry(max * random.nextDouble()).getValue();
    }

    @Override
    public List<NationalityTemplate> getNationalities() {
        return StreamEx.of(this.nationalities.values()).toList();
    }

    @Override
    public NationalityTemplate getNationality(int id) {
        return this.nationalities.get(id);
    }

    @Override
    public List<FractionTemplate> getFractions() {
        return StreamEx.of(this.fractions.values()).toList();
    }

    @Override
    public FractionTemplate getFraction(int id) {
        return this.fractions.get(id);
    }

    @Override
    public FractionTemplate getNextFraction() {
        return this.getNextRandom(this.getFractions());
    }

    @Override
    public List<FractionTemplate> getFractionsForRandomNpc() {
        return this.fractionsForRandomNpc;
    }

    @Override
    public List<GenderTemplate> getGenders() {
        return StreamEx.of(this.genders.values()).toList();
    }

    @Override
    public GenderTemplate getGender(int id) {
        return this.genders.get(id);
    }

    @Override
    public GenderTemplate getGenderByClass(int classId) {
        NavigableMap<Double, SexClassTemplate> map = this.sexClasses.get(classId);
        double max = (Double)map.lastKey();
        return this.getGender(map.ceilingEntry(max * random.nextDouble()).getValue().getSexId());
    }

    @Override
    public GenderTemplate getNextGender() {
        return this.getNextRandom(this.getGenders());
    }

    @Override
    public List<RaceTemplate> getRaces() {
        return StreamEx.of(this.races.values()).toList();
    }

    @Override
    public RaceTemplate getRace(int id) {
        return this.races.get(id);
    }

    @Override
    public RaceTemplate getNextRace(int nationalityId) {
        NavigableMap<Double, OperatorPrefabsTemplate> prefabs = this.operatorPrefabs.get(nationalityId);
        double max = (Double)prefabs.lastKey();
        return this.getRace(prefabs.ceilingEntry(max * random.nextDouble()).getValue().getRaceId());
    }

    @Override
    public List<RankTemplate> getRanks() {
        return StreamEx.of(this.ranks.values()).toList();
    }

    @Override
    public RankTemplate getRank(int id) {
        return this.ranks.get(id);
    }

    @Override
    public RankTemplate getStartRank() {
        return ((StreamEx)StreamEx.of(this.ranks.values()).filter(RankTemplate::isStart)).findFirst().orElseGet(() -> this.getRankForExperience(0L));
    }

    @Override
    public RankTemplate getRankForExperience(long experience) {
        return this.experienceRanks.floorEntry(experience).getValue();
    }

    @Override
    public List<RarityTemplate> getRarities() {
        return StreamEx.of(this.rarities.values()).toList();
    }

    @Override
    public RarityTemplate getRarity(int id) {
        return this.rarities.get(id);
    }

    @Override
    public RarityTemplate getRarityByName(OperatorRarity rarity) {
        return this.raritiesByName.get((Object)rarity);
    }

    @Override
    public RarityTemplate getNextRarity() {
        double max = (Double)this.randomRarities.lastKey();
        return this.randomRarities.ceilingEntry(max * random.nextDouble()).getValue();
    }

    @Override
    public List<SpikeDistributionTemplate> getSpikeDistributions() {
        return StreamEx.of(this.spikeDistributions.values()).toList();
    }

    @Override
    public SpikeDistributionTemplate getSpikeDistribution(int raceId, int rarityId) {
        return (SpikeDistributionTemplate)((StreamEx)((StreamEx)StreamEx.of(this.spikeDistributions.values()).filter(template -> template.getRaceId() == raceId)).filter(template -> template.getRarityId() == rarityId)).findFirst().orElseThrow(() -> new ErrorException("not found spike distribution for race=" + raceId + " rarity=" + rarityId));
    }

    @Override
    public List<FirstUnitsGenerationTemplate> getFirstUnitsGenerations(int fractionId) {
        return this.firstUnitsGenerations.get(fractionId);
    }

    @Override
    public NameTemplate getName(int nationalityId, int sexId) {
        List<NameTemplate> names = this.names.get(nationalityId).get(sexId);
        return names.get(random.nextInt(names.size()));
    }

    @Override
    public List<OperatorDecorationTemplate> getOperatorDecorations() {
        return Lists.newArrayList(this.operatorDecorations.values());
    }

    @Override
    public Optional<OperatorDecorationTemplate> getOperatorDecoration(int decorationId) {
        return Optional.ofNullable(this.operatorDecorations.get(decorationId));
    }

    @Override
    public OperatorDecorationTemplate getOperatorDecorationByGUID(String guid) {
        return this.operatorDecorationsByGUID.get(guid);
    }

    @Override
    public List<ClassDecoration> getClassDecorations(int classId) {
        return this.classDecorations.getOrDefault(classId, Lists.newArrayList());
    }
}

