/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.services.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import one.util.streamex.StreamEx;
import ru.quadcom.datapack.common.RandomUtils;
import ru.quadcom.datapack.domains.item.Item;
import ru.quadcom.datapack.domains.item.ItemOwnerType;
import ru.quadcom.datapack.domains.operator.EquipmentSlot;
import ru.quadcom.datapack.domains.operator.Operator;
import ru.quadcom.datapack.domains.operator.OperatorType;
import ru.quadcom.datapack.domains.operator.UnitTraitGroupType;
import ru.quadcom.datapack.services.IDataPack;
import ru.quadcom.datapack.services.IDomainFactory;
import ru.quadcom.datapack.templates.common.DecorationType;
import ru.quadcom.datapack.templates.common.UnitSkinColor;
import ru.quadcom.datapack.templates.common.UnitSkinPart;
import ru.quadcom.datapack.templates.operator.AvatarTemplate;
import ru.quadcom.datapack.templates.operator.ClassDecoration;
import ru.quadcom.datapack.templates.operator.ClassTemplate;
import ru.quadcom.datapack.templates.operator.FirstUnitsGenerationTemplate;
import ru.quadcom.datapack.templates.operator.FractionTemplate;
import ru.quadcom.datapack.templates.operator.GenderTemplate;
import ru.quadcom.datapack.templates.operator.HeadKit;
import ru.quadcom.datapack.templates.operator.NameTemplate;
import ru.quadcom.datapack.templates.operator.NationalityTemplate;
import ru.quadcom.datapack.templates.operator.OperatorDecorationTemplate;
import ru.quadcom.datapack.templates.operator.RaceTemplate;
import ru.quadcom.datapack.templates.operator.RankTemplate;
import ru.quadcom.datapack.templates.operator.RarityTemplate;
import ru.quadcom.datapack.templates.operator.Sex;
import ru.quadcom.datapack.templates.operator.SpikeDistributionTemplate;
import ru.quadcom.datapack.templates.operator.UnitTraitTemplate;
import ru.quadcom.datapack.templates.operator.VoiceTemplate;

public abstract class AbstractDomainFactory
implements IDomainFactory {
    private final IDataPack dataPack;
    private static final AtomicLong fakeIdFactory = new AtomicLong(0L);

    public AbstractDomainFactory(IDataPack dataPack) {
        this.dataPack = dataPack;
    }

    @Override
    public <T extends Operator> T initOperator(T operator, FractionTemplate fraction, ClassTemplate baseClass, RarityTemplate rarity, NationalityTemplate nationality) {
        return this.initOperator(operator, fraction, baseClass, rarity, nationality, null, false);
    }

    public <T extends Operator> T initOperator(T operator, FractionTemplate fraction, ClassTemplate baseClass, RarityTemplate rarity, NationalityTemplate nationality, Sex sex, boolean isFirstGeneration) {
        RankTemplate startRank = this.dataPack.getOperatorPack().getStartRank();
        operator.setRankId(startRank.getId());
        if (baseClass == null) {
            baseClass = this.dataPack.getOperatorPack().getNextBaseClass();
        }
        if (rarity == null) {
            rarity = this.dataPack.getOperatorPack().getNextRarity();
        }
        if (nationality == null) {
            if (Math.random() > 0.5) {
                nationality = this.dataPack.getOperatorPack().getNationality(fraction.getDefaultNationality());
            } else {
                List otherNationalities = ((StreamEx)StreamEx.of(this.dataPack.getOperatorPack().getNationalities()).filter(template -> template.getId() != fraction.getDefaultNationality())).toList();
                Collections.shuffle(otherNationalities);
                nationality = (NationalityTemplate)otherNationalities.get(0);
            }
        }
        operator.addClass(baseClass);
        operator.setRarityId(rarity.getId());
        operator.setNationalityId(nationality.getId());
        operator.setSkillPoints(rarity.getBonusSkillPoint());
        RaceTemplate race = this.dataPack.getOperatorPack().getNextRace(nationality.getId());
        operator.setRaceId(race.getId());
        GenderTemplate gender = sex == null ? this.dataPack.getOperatorPack().getGenderByClass(baseClass.getId()) : this.dataPack.getOperatorPack().getGenderByClass(baseClass.getId(), sex);
        operator.setGenderId(gender.getId());
        SpikeDistributionTemplate spikeDistribution = this.dataPack.getOperatorPack().getSpikeDistribution(race.getId(), rarity.getId());
        operator.setEndurance(RandomUtils.getRandomInt(spikeDistribution.getMinEndurance(), spikeDistribution.getMaxEndurance()));
        operator.setIntelligence(RandomUtils.getRandomInt(spikeDistribution.getMinIntelligence(), spikeDistribution.getMaxIntelligence()));
        operator.setKnack(RandomUtils.getRandomInt(spikeDistribution.getMinKnack(), spikeDistribution.getMaxKnack()));
        operator.setPerception(RandomUtils.getRandomInt(spikeDistribution.getMinPerception(), spikeDistribution.getMaxPerception()));
        operator.setStrength(RandomUtils.getRandomInt(spikeDistribution.getMinStrength(), spikeDistribution.getMaxStrength()));
        NameTemplate name1 = this.dataPack.getOperatorPack().getName(nationality.getId(), gender.getId());
        NameTemplate name2 = this.dataPack.getOperatorPack().getName(nationality.getId(), gender.getId());
        operator.setName(name1.getName() + " " + name2.getSurname());
        AvatarTemplate avatarTemplate = this.dataPack.getOperatorPack().getNextAvatar(race, gender);
        operator.setAvatarName(avatarTemplate.getAvatarName());
        operator.addAvatarLayers(avatarTemplate.getNextAvatarLayers());
        Map<DecorationType, UnitSkinPart> unitSkinPartList = this.createRandomDecorationMap(race, operator.getClassIds());
        operator.setSkinParts(Lists.newArrayList(unitSkinPartList.values()));
        UnitSkinColor unitSkinColor = new UnitSkinColor(fraction.getCamouflageIndex(), fraction.getLutIndex(), fraction.getSolidIndex(), race.getSkinIndex());
        operator.setSkinColors(unitSkinColor);
        UnitTraitTemplate backgroundTrait = this.dataPack.getOperatorPack().getRandomUnitTraitByGroupType(UnitTraitGroupType.Background);
        UnitTraitTemplate personalityTrait = this.dataPack.getOperatorPack().getRandomUnitTraitByGroupType(UnitTraitGroupType.Personality);
        operator.addTrait(backgroundTrait.getUnitTraitType());
        operator.addTrait(personalityTrait.getUnitTraitType());
        operator.setBodyKitSetId(this.dataPack.getOperatorPack().getRandomBodyKitSetForPlayer().getId());
        UnitSkinPart headSkinPart = unitSkinPartList.get((Object)DecorationType.head);
        HashSet headKitList = Sets.newHashSet();
        int headKitMask = 0;
        for (int priority = 1; priority < 5; ++priority) {
            HeadKit headKit2;
            List headKits = ((StreamEx)((StreamEx)StreamEx.of(this.dataPack.getOperatorPack().getHeadKitByPriority(priority)).filter(headKit -> headKit.getHeadTypeList().contains(headSkinPart.getGuid()))).filter(headKit -> headKit.getGenderId() == 0 || headKit.getGenderId() == gender.getId())).toList();
            HeadKit headKit3 = headKit2 = !headKits.isEmpty() ? (HeadKit)RandomUtils.getRandomListItem(headKits) : null;
            if (headKit2 == null || headKit2.getMask() <= 0 || (headKitMask & headKit2.getMask()) != 0) continue;
            headKitList.add(headKit2.getId());
            headKitMask |= headKit2.getMask();
        }
        operator.setHeadKitIdList(headKitList);
        VoiceTemplate voiceTemplate = this.dataPack.getOperatorPack().getVoiceForPlayer(gender.getSex(), isFirstGeneration);
        operator.setVoiceId(voiceTemplate.getId());
        operator.setType(OperatorType.FIGHTER);
        operator.setLastIncrementedStat(-1);
        return operator;
    }

    @Override
    public <T extends Operator> T initOperator(T operator, FractionTemplate fraction, FirstUnitsGenerationTemplate prop) {
        if (prop != null) {
            ClassTemplate baseClass = this.dataPack.getOperatorPack().getClass(prop.getClassId());
            RarityTemplate rarity = this.dataPack.getOperatorPack().getRarity(prop.getRarityId());
            NationalityTemplate nationality = this.dataPack.getOperatorPack().getNationality(fraction.getDefaultNationality());
            Sex sex = prop.getSex();
            return this.initOperator(operator, fraction, baseClass, rarity, nationality, sex, true);
        }
        return this.initOperator(operator, fraction, null, null, null);
    }

    @Override
    public Map<DecorationType, UnitSkinPart> createRandomDecorationMap(RaceTemplate race, Collection<Integer> classIds) {
        HashMap decoration = Maps.newHashMap();
        List<Object> classDecorations = Lists.newArrayList();
        for (Integer classId : classIds) {
            classDecorations = this.dataPack.getOperatorPack().getClassDecorations(classId);
            if (classDecorations.isEmpty()) continue;
            break;
        }
        Map map = ((StreamEx)((StreamEx)((StreamEx)StreamEx.of(this.dataPack.getOperatorPack().getOperatorDecorations()).filter(OperatorDecorationTemplate::isAvailable)).filter(template -> template.getRaceId() == 0 || race == null || template.getRaceId() == race.getId())).map(OperatorDecorationTemplate::getUnitSkinPart).filter(unitSkinPart -> unitSkinPart.getSlotId() != null)).groupingBy(UnitSkinPart::getSlotId);
        for (Map.Entry entry : map.entrySet()) {
            List list = (List)entry.getValue();
            UnitSkinPart part = (UnitSkinPart)RandomUtils.getRandomListItem(list);
            decoration.put(part.getSlotId(), part);
        }
        for (ClassDecoration classDecoration : classDecorations) {
            this.dataPack.getOperatorPack().getOperatorDecoration(classDecoration.getOperatorDecorationId()).ifPresent(operatorDecorationTemplate -> {
                UnitSkinPart part = operatorDecorationTemplate.getUnitSkinPart();
                decoration.put(part.getSlotId(), part);
            });
        }
        return decoration;
    }

    @Override
    public List<UnitSkinPart> createRandomDecoration(Collection<Integer> classIds) {
        Map<DecorationType, UnitSkinPart> decoration = this.createRandomDecorationMap(null, classIds);
        return Lists.newArrayList(decoration.values());
    }

    @Override
    public Item createFakeItem(Operator operator, EquipmentSlot slot, int templateId) {
        Item fakeItem = new Item();
        fakeItem.setItemTemplateId(templateId);
        fakeItem.setItemOwnerType(ItemOwnerType.OPERATOR);
        fakeItem.setOwnerInstanceId(operator.getId());
        fakeItem.setProfileId(operator.getProfileId());
        fakeItem.setSlotNumber(slot.getEquipmentOrder());
        fakeItem.setCount(1);
        fakeItem.setId(AbstractDomainFactory.getNextFakeId());
        fakeItem.setDurability(this.dataPack.getItemPack().getItemTemplate(templateId).getDurability());
        return fakeItem;
    }

    public static long getNextFakeId() {
        return fakeIdFactory.accumulateAndGet(-1L, (current, delta) -> {
            long next = current + delta;
            if (next > 0L) {
                next = -1L;
            }
            return next;
        });
    }
}

