/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.loaders.impl;

import com.google.common.collect.Maps;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import one.util.streamex.StreamEx;
import ru.quadcom.datapack.domains.item.ItemType;
import ru.quadcom.datapack.loaders.Loader;
import ru.quadcom.datapack.templates.common.LootDrop;

public class LootDrop2Loader
extends Loader<LootDrop> {
    public LootDrop2Loader(String resourceUrl, String prefix) {
        super(resourceUrl, prefix);
    }

    @Override
    protected Type getType() {
        return new TypeToken<List<LootDrop>>(){}.getType();
    }

    @Override
    public Map<String, Map<Boolean, Map<Integer, Map<Double, ItemType>>>> load(String fileName) {
        List lootDrops = StreamEx.of(this.load0(fileName)).toList();
        HashMap map = Maps.newHashMap();
        for (LootDrop lootDrop : lootDrops) {
            map.compute(lootDrop.getDropListName(), (key2, map2) -> {
                if (map2 == null) {
                    map2 = Maps.newHashMap();
                }
                map2.compute(lootDrop.isWin(), (key3, map3) -> {
                    if (map3 == null) {
                        map3 = Maps.newHashMap();
                    }
                    map3.computeIfAbsent(lootDrop.getRank(), key4 -> {
                        TreeMap map4 = Maps.newTreeMap();
                        for (Map.Entry<ItemType, Double> entry : lootDrop.getChances().entrySet()) {
                            if (!(entry.getValue() > 0.0)) continue;
                            map4.putIfAbsent(entry.getValue(), entry.getKey());
                        }
                        return map4;
                    });
                    return map3;
                });
                return map2;
            });
        }
        return map;
    }
}

