/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.templates.operator;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum OperatorRank {
    PRIVATE(1),
    SPECIALIST(2),
    CORPORAL(3),
    SERGEANT(4),
    MASTER_SERGEANT(5),
    ENSIGN(6),
    LIEUTENANT(7),
    SENIOR_LIEUTENANT(8),
    CAPTAIN(9),
    MAJOR(10),
    LIEUTENANT_COLONEL(11),
    COLONEL(12);

    private int level;
    private static Map<Integer, OperatorRank> mapByLevel;

    private OperatorRank(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public OperatorRank getByLevel(int level) {
        OperatorRank rank = mapByLevel.get(level);
        if (rank == null) {
            throw new IllegalArgumentException("for argument " + level);
        }
        return rank;
    }

    static {
        mapByLevel = Arrays.stream(OperatorRank.values()).collect(Collectors.toMap(OperatorRank::getLevel, Function.identity()));
    }
}

