/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.services.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import ru.quadcom.datapack.common.RandomValueProvider;
import ru.quadcom.datapack.domains.item.ItemType;
import ru.quadcom.datapack.loaders.impl.ItemClanShopTemplateLoader;
import ru.quadcom.datapack.loaders.impl.ItemShopLoader;
import ru.quadcom.datapack.loaders.impl.ItemSpecialShopGroupLoader;
import ru.quadcom.datapack.loaders.impl.ItemSpecialShopWeightLoader;
import ru.quadcom.datapack.loaders.impl.OperatorShopTemplateLoader;
import ru.quadcom.datapack.loaders.impl.PVPShopItemLoader;
import ru.quadcom.datapack.services.IShopPack;
import ru.quadcom.datapack.templates.operator.FractionTemplate;
import ru.quadcom.datapack.templates.operator.RarityTemplate;
import ru.quadcom.datapack.templates.shop.ItemClanShopTemplate;
import ru.quadcom.datapack.templates.shop.ItemShopTemplate;
import ru.quadcom.datapack.templates.shop.ItemSpecialShopWeight;
import ru.quadcom.datapack.templates.shop.OperatorShopTemplate;
import ru.quadcom.datapack.templates.shop.PVPShopItemTemplate;

public class ShopPack
implements IShopPack {
    private final Map<Integer, Map<Integer, ItemShopTemplate>> itemShop;
    private final NavigableMap<Integer, RandomValueProvider<ItemType>> itemSpecialShopGroup;
    private final Map<ItemType, NavigableMap<Integer, RandomValueProvider<ItemSpecialShopWeight>>> itemSpecialShopWeight;
    private final NavigableMap<Integer, RandomValueProvider<ItemType>> itemSpecialShopGroup2;
    private final Map<ItemType, NavigableMap<Integer, RandomValueProvider<ItemSpecialShopWeight>>> itemSpecialShopWeight2;
    private final Map<Integer, PVPShopItemTemplate> pvpShopItems;
    private final Map<Integer, ItemClanShopTemplate> clanShopContent;
    private final Map<OperatorShopTemplate.ShopType, List<RandomValueProvider<OperatorShopTemplate>>> operatorShop;
    private final Map<Integer, Map<Integer, OperatorShopTemplate>> operatorShopPrice;

    public ShopPack(String resourceUrl) {
        this.itemShop = StreamEx.of((Collection)new ItemShopLoader(resourceUrl).load("item_shop.json")).groupingBy(ItemShopTemplate::getFractionId, Collectors.toMap(ItemShopTemplate::getItemTemplateId, template -> template));
        this.itemSpecialShopGroup = new ItemSpecialShopGroupLoader(resourceUrl).load("item_special_shop_group.json");
        this.itemSpecialShopWeight = new ItemSpecialShopWeightLoader(resourceUrl).load("item_special_shop_weight.json");
        this.itemSpecialShopGroup2 = new ItemSpecialShopGroupLoader(resourceUrl).load("item_special_shop_group_2.json");
        this.itemSpecialShopWeight2 = new ItemSpecialShopWeightLoader(resourceUrl).load("item_special_shop_weight_2.json");
        this.pvpShopItems = new PVPShopItemLoader(resourceUrl).load("pvp_shop.json");
        this.clanShopContent = Collections.unmodifiableMap(new ItemClanShopTemplateLoader(resourceUrl).load("clan_shop.json"));
        Object operatorShopList = new OperatorShopTemplateLoader(resourceUrl).load("operator_shop.json");
        this.operatorShop = operatorShopList.stream().collect(Collectors.groupingBy(OperatorShopTemplate::getType, Collectors.groupingBy(OperatorShopTemplate::getSlot))).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Map)e.getValue()).values().stream().map(operatorShopTemplates -> {
            RandomValueProvider<OperatorShopTemplate> p = RandomValueProvider.forWeights();
            p.addAll(operatorShopTemplates, Function.identity(), OperatorShopTemplate::getRarityDropChance);
            return p;
        }).collect(Collectors.toList())));
        this.operatorShopPrice = operatorShopList.stream().collect(Collectors.groupingBy(OperatorShopTemplate::getSlot, Collectors.toMap(OperatorShopTemplate::getUnitRarity, Function.identity())));
    }

    @Override
    public long getOperatorShopPrice(int slot, RarityTemplate template) {
        return this.operatorShopPrice.get(slot).get(template.getId()).getPrice();
    }

    @Override
    public List<RandomValueProvider<OperatorShopTemplate>> getOperatorShopRandomProviders(OperatorShopTemplate.ShopType type) {
        return this.operatorShop.getOrDefault((Object)type, Collections.emptyList());
    }

    @Override
    public Map<Integer, ItemClanShopTemplate> getClanShopContent() {
        return this.clanShopContent;
    }

    @Override
    public Optional<ItemClanShopTemplate> getClanShopItem(int position) {
        return Optional.ofNullable(this.clanShopContent.get(position));
    }

    @Override
    public Map<Integer, ItemShopTemplate> getItemShop(FractionTemplate fractionTemplate) {
        return this.itemShop.get(fractionTemplate.getId());
    }

    @Override
    public Map<Integer, PVPShopItemTemplate> getPVPItemShop() {
        return this.pvpShopItems;
    }

    @Override
    public List<Integer> getSpecialShopItem(int level, int count) {
        return ShopPack.getSpecialShopItem(level, count, this.itemSpecialShopGroup, this.itemSpecialShopWeight);
    }

    @Override
    public List<Integer> getSpecialShopItem2(int level, int count) {
        return ShopPack.getSpecialShopItem(level, count, this.itemSpecialShopGroup2, this.itemSpecialShopWeight2);
    }

    private static List<Integer> getSpecialShopItem(int level, int count, NavigableMap<Integer, RandomValueProvider<ItemType>> itemSpecialShopGroup, Map<ItemType, NavigableMap<Integer, RandomValueProvider<ItemSpecialShopWeight>>> itemSpecialShopWeight) {
        HashSet used = Sets.newHashSet();
        ArrayList ids = Lists.newArrayList();
        for (int i = 0; i < ItemType.values().length; ++i) {
            RandomValueProvider<ItemType> group;
            Map.Entry<Integer, RandomValueProvider<ItemType>> groupEntry = itemSpecialShopGroup.floorEntry(level);
            if (groupEntry != null && (group = groupEntry.getValue()) != null) {
                group = RandomValueProvider.from(group, type -> !used.contains(type));
                group.nextRandom().ifPresent(type -> {
                    RandomValueProvider weightsByLevel;
                    Map.Entry weightsForLevelEntry;
                    NavigableMap weights = (NavigableMap)itemSpecialShopWeight.get(type);
                    if (weights != null && (weightsForLevelEntry = weights.floorEntry(level)) != null && (weightsByLevel = (RandomValueProvider)weightsForLevelEntry.getValue()) != null) {
                        weightsByLevel.nextRandom().ifPresent(weight -> ids.add(weight.getItemTemplateId()));
                    }
                    used.add(type);
                });
            }
            if (ids.size() >= count) break;
        }
        return ids;
    }
}

