/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.services.impl;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import ru.quadcom.datapack.loaders.impl.BPLevelLoader;
import ru.quadcom.datapack.loaders.impl.BPQuestLoader;
import ru.quadcom.datapack.services.IBPPack;
import ru.quadcom.datapack.templates.battlepass.BPLevelTemplate;
import ru.quadcom.datapack.templates.battlepass.BPQuestTemplate;

public class BPPack
implements IBPPack {
    private final Map<Integer, BPLevelTemplate> bpLevelMap;
    private final TreeMap<Long, BPLevelTemplate> bpLevelMapByExp;
    private final List<BPLevelTemplate> bpLevelList;
    private final Map<Integer, BPQuestTemplate> bpQuestMap;
    private final List<BPQuestTemplate> bpQuestList;

    public BPPack(String resourceUrl) {
        this.bpLevelMap = new BPLevelLoader(resourceUrl).load("bp_levels.json");
        this.bpLevelList = ImmutableList.copyOf(this.bpLevelMap.values());
        this.bpLevelMapByExp = this.bpLevelList.stream().collect(Collectors.toMap(BPLevelTemplate::getExp, Function.identity(), (a, b) -> b, TreeMap::new));
        this.bpQuestMap = new BPQuestLoader(resourceUrl).load("bp_quests.json");
        this.bpQuestList = ImmutableList.copyOf(this.bpQuestMap.values());
    }

    @Override
    public Optional<BPLevelTemplate> getBpLevel(int level) {
        return Optional.ofNullable(this.bpLevelMap.get(level));
    }

    @Override
    public Optional<BPQuestTemplate> getBpQuest(int questId) {
        return Optional.ofNullable(this.bpQuestMap.get(questId));
    }

    @Override
    public List<BPLevelTemplate> getBpLevels() {
        return this.bpLevelList;
    }

    @Override
    public List<BPQuestTemplate> getBpQuests() {
        return this.bpQuestList;
    }

    @Override
    public BPLevelTemplate getBpLevelByExp(long exp) {
        return this.bpLevelMapByExp.floorEntry(exp).getValue();
    }
}

