/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.loaders.impl;

import com.google.common.collect.Maps;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.quadcom.datapack.domains.MissionResult;
import ru.quadcom.datapack.domains.MoneyReward;
import ru.quadcom.datapack.loaders.Loader;

public class MoneyRewardLoader
extends Loader<MoneyReward> {
    public MoneyRewardLoader(String resourceUrl, String prefix) {
        super(resourceUrl, prefix);
    }

    @Override
    protected Type getType() {
        return new TypeToken<List<MoneyReward>>(){}.getType();
    }

    @Override
    public Map<String, Map<MissionResult, Map<Integer, MoneyReward>>> load(String fileName) {
        HashMap result = Maps.newHashMap();
        for (MoneyReward moneyReward : this.load0(fileName)) {
            Map mapMR = result.getOrDefault(moneyReward.getMoneyRewardName(), Maps.newHashMap());
            result.putIfAbsent(moneyReward.getMoneyRewardName(), mapMR);
            Map mapR = mapMR.getOrDefault((Object)moneyReward.getMissionResult(), Maps.newHashMap());
            mapMR.putIfAbsent(moneyReward.getMissionResult(), mapR);
            mapR.putIfAbsent(moneyReward.getAccRank(), moneyReward);
        }
        return result;
    }
}

