/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.domains.operator;

import ru.quadcom.datapack.domains.item.ItemType;

public enum EquipmentSlot {
    SLOT0(0, 1, ItemType.WEAPON),
    SLOT1(1, 1, ItemType.ARMOR),
    SLOT2(2, 1, ItemType.AMMO),
    SLOT3(3, 1, ItemType.GADGET, ItemType.GRENADE, ItemType.FIRST_AID, ItemType.MINE, ItemType.SCANNER),
    SLOT4(4, 1, ItemType.GADGET, ItemType.GRENADE, ItemType.FIRST_AID, ItemType.MINE, ItemType.SCANNER),
    SLOT5(5, 1, ItemType.GADGET, ItemType.GRENADE, ItemType.FIRST_AID, ItemType.MINE, ItemType.SCANNER);

    private int equipmentDefaultOrder;
    private int equipmentOrder;
    private int size;
    private ItemType[] supportTypes;

    private EquipmentSlot(int equipmentOrder, int size, ItemType ... supportTypes) {
        this.equipmentOrder = equipmentOrder;
        this.equipmentDefaultOrder = equipmentOrder + 100;
        this.size = size;
        this.supportTypes = supportTypes;
    }

    public ItemType[] getSupportTypes() {
        return this.supportTypes;
    }

    public boolean isSupported(ItemType itemType) {
        for (ItemType supportType : this.supportTypes) {
            if (supportType != itemType) continue;
            return true;
        }
        return false;
    }

    public int getSize() {
        return this.size;
    }

    public int getEquipmentDefaultOrder() {
        return this.equipmentDefaultOrder;
    }

    public int getEquipmentOrder() {
        return this.equipmentOrder;
    }

    public static boolean isDefault(int order) {
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            if (equipmentSlot.equipmentDefaultOrder == order) {
                return true;
            }
            if (equipmentSlot.equipmentOrder != order) continue;
            return false;
        }
        throw new IllegalArgumentException("EquipmentSlot with order " + order + "not exist");
    }

    public static EquipmentSlot valueOfOrder(int order) {
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            if (equipmentSlot.equipmentOrder != order && equipmentSlot.equipmentDefaultOrder != order) continue;
            return equipmentSlot;
        }
        throw new IllegalArgumentException("EquipmentSlot with order " + order + "not exist");
    }
}

