/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.common;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import ru.quadcom.datapack.domains.operator.Operator;

public enum StatHelper {
    ENDURANCE(0){

        @Override
        public int getValue(Operator operator) {
            return operator.getEndurance();
        }

        @Override
        public void changeValue(Operator operator, int delta) {
            operator.setEndurance(operator.getEndurance() + delta);
        }

        @Override
        public void setCounter(Operator operator, int value) {
            operator.setEnduranceActionCounter(value);
        }

        @Override
        public int getCounter(Operator operator) {
            return operator.getEnduranceActionCounter();
        }

        @Override
        public void changeCounter(Operator operator, int delta) {
            operator.setEnduranceActionCounter(operator.getEnduranceActionCounter() + delta);
        }
    }
    ,
    INTELLIGENCE(1){

        @Override
        public int getValue(Operator operator) {
            return operator.getIntelligence();
        }

        @Override
        public void changeValue(Operator operator, int delta) {
            operator.setIntelligence(operator.getIntelligence() + delta);
        }

        @Override
        public void setCounter(Operator operator, int value) {
            operator.setIntelligenceActionCounter(value);
        }

        @Override
        public int getCounter(Operator operator) {
            return operator.getIntelligenceActionCounter();
        }

        @Override
        public void changeCounter(Operator operator, int delta) {
            operator.setIntelligenceActionCounter(operator.getIntelligenceActionCounter() + delta);
        }
    }
    ,
    KNACK(2){

        @Override
        public int getValue(Operator operator) {
            return operator.getKnack();
        }

        @Override
        public void changeValue(Operator operator, int delta) {
            operator.setKnack(operator.getKnack() + delta);
        }

        @Override
        public void setCounter(Operator operator, int value) {
            operator.setKnackActionCounter(value);
        }

        @Override
        public int getCounter(Operator operator) {
            return operator.getKnackActionCounter();
        }

        @Override
        public void changeCounter(Operator operator, int delta) {
            operator.setKnackActionCounter(operator.getKnackActionCounter() + delta);
        }
    }
    ,
    PERCEPTION(3){

        @Override
        public int getValue(Operator operator) {
            return operator.getPerception();
        }

        @Override
        public void changeValue(Operator operator, int delta) {
            operator.setPerception(operator.getPerception() + delta);
        }

        @Override
        public void setCounter(Operator operator, int value) {
            operator.setPerceptionActionCounter(value);
        }

        @Override
        public int getCounter(Operator operator) {
            return operator.getPerceptionActionCounter();
        }

        @Override
        public void changeCounter(Operator operator, int delta) {
            operator.setPerceptionActionCounter(operator.getPerceptionActionCounter() + delta);
        }
    }
    ,
    STRENGTH(4){

        @Override
        public int getValue(Operator operator) {
            return operator.getStrength();
        }

        @Override
        public void changeValue(Operator operator, int delta) {
            operator.setStrength(operator.getStrength() + delta);
        }

        @Override
        public void setCounter(Operator operator, int value) {
            operator.setStrengthActionCounter(value);
        }

        @Override
        public int getCounter(Operator operator) {
            return operator.getStrengthActionCounter();
        }

        @Override
        public void changeCounter(Operator operator, int delta) {
            operator.setStrengthActionCounter(operator.getStrengthActionCounter() + delta);
        }
    };

    private static final Map<Integer, StatHelper> map;
    private final int index;

    private StatHelper(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public static StatHelper getByIndex(int index) {
        StatHelper stat = map.get(index);
        if (stat == null) {
            throw new IllegalArgumentException("Not found Stat with index=" + index);
        }
        return stat;
    }

    public static boolean indexExists(int index) {
        return map.containsKey(index);
    }

    public abstract int getValue(Operator var1);

    public abstract void changeValue(Operator var1, int var2);

    @Deprecated
    public abstract void setCounter(Operator var1, int var2);

    @Deprecated
    public abstract int getCounter(Operator var1);

    @Deprecated
    public abstract void changeCounter(Operator var1, int var2);

    static {
        map = Arrays.stream(StatHelper.values()).collect(Collectors.toMap(StatHelper::getIndex, Function.identity()));
    }
}

