/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.common;

import com.google.common.collect.Maps;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;

public class RandomValueProvider<T> {
    private final NavigableMap<Double, AbstractMap.SimpleEntry<T, Double>> map = Maps.newTreeMap();
    private double calculatedMaxWeight;
    private final double maxChance;
    private static final RandomValueProvider<Object> EMPTY = new EmptyRandomValueProvider<Object>(0.0);

    private RandomValueProvider(double maxChance) {
        this.maxChance = maxChance;
    }

    public static <T> RandomValueProvider<T> from(RandomValueProvider<T> from, Function<T, Boolean> checker) {
        RandomValueProvider<T> to = new RandomValueProvider<T>(super.getMaxChance());
        Collection<AbstractMap.SimpleEntry<T, Double>> entries = super.getEntries();
        for (AbstractMap.SimpleEntry<T, Double> entry : entries) {
            if (!checker.apply(entry.getKey()).booleanValue()) continue;
            to.add(entry.getKey(), entry.getValue());
        }
        return to;
    }

    private Collection<AbstractMap.SimpleEntry<T, Double>> getEntries() {
        return this.map.values();
    }

    public static <T> RandomValueProvider<T> forWeights() {
        return new RandomValueProvider<T>(0.0);
    }

    public static <T> RandomValueProvider<T> forChances() {
        return new RandomValueProvider<T>(100.0);
    }

    public static <T> RandomValueProvider<T> forShares() {
        return new RandomValueProvider<T>(1.0);
    }

    public void add(T value, double weight) {
        if (weight > 0.0) {
            this.calculatedMaxWeight += weight;
            this.map.put(this.calculatedMaxWeight, new AbstractMap.SimpleEntry<T, Double>(value, weight));
        }
    }

    public <E> void addAll(Collection<E> values, Function<E, T> valueExtractor, Function<T, Double> weightExtractor) {
        values.forEach(object -> {
            Object value = valueExtractor.apply(object);
            this.add(value, (Double)weightExtractor.apply(value));
        });
    }

    public Optional<T> nextRandom() {
        double maxWeight = this.maxChance > 0.0 && this.calculatedMaxWeight < this.maxChance ? this.maxChance : this.calculatedMaxWeight;
        double value = ThreadLocalRandom.current().nextDouble() * maxWeight;
        Map.Entry<Double, AbstractMap.SimpleEntry<T, Double>> ceilingEntry = this.map.ceilingEntry(value);
        return ceilingEntry == null ? Optional.empty() : Optional.of(ceilingEntry.getValue()).map(AbstractMap.SimpleEntry::getKey);
    }

    public static <T> RandomValueProvider<T> empty() {
        RandomValueProvider<Object> provider = EMPTY;
        return provider;
    }

    private double getMaxChance() {
        return this.maxChance;
    }

    private static class EmptyRandomValueProvider<T>
    extends RandomValueProvider<T> {
        private EmptyRandomValueProvider(double maxChance) {
            super(maxChance);
        }

        @Override
        public void add(Object value, double weight) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<T> nextRandom() {
            return Optional.empty();
        }
    }
}

