/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.loaders;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public abstract class Loader<R> {
    private String resourceUrl;
    private String prefix;
    private static Gson gson = new GsonBuilder().registerTypeAdapter(LocalDate.class, (json, typeOfT, context) -> LocalDate.parse(json.getAsString(), DateTimeFormatter.ofPattern("yyyy-MM-dd"))).registerTypeAdapter(LocalTime.class, (json, typeOfT, context) -> LocalTime.parse(json.getAsString(), DateTimeFormatter.ofPattern("HH:mm:ss"))).create();

    public Loader(String resourceUrl) {
        this.resourceUrl = resourceUrl;
        this.prefix = "";
    }

    public Loader(String resourceUrl, String prefix) {
        this.resourceUrl = resourceUrl;
        this.prefix = prefix;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<R> load0(String fileName) {
        File file = new File(this.resourceUrl + "/" + this.prefix);
        if (!file.exists()) {
            throw new RuntimeException(this.resourceUrl + " dir not found");
        }
        File[] files = file.listFiles(name -> name.getName().equals(fileName));
        if (files == null) return Lists.newArrayList();
        if (files.length == 0) {
            return Lists.newArrayList();
        }
        try (FileReader fr = new FileReader(files[0]);){
            List list = (List)gson.fromJson((Reader)fr, this.getType());
            return list;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(fileName + " file not found", e);
        }
        catch (IOException e) {
            throw new RuntimeException(fileName + " file read error", e);
        }
    }

    protected abstract Type getType();

    public abstract Object load(String var1);
}

