/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.services.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.quadcom.datapack.domains.AIClass;
import ru.quadcom.datapack.loaders.impl.AIClassLoader;
import ru.quadcom.datapack.loaders.impl.ClanSuperRewardsLoader;
import ru.quadcom.datapack.loaders.impl.HardPvpGroupsLoader;
import ru.quadcom.datapack.loaders.impl.HardPvpUnitsLoader;
import ru.quadcom.datapack.loaders.impl.NPCGenerationLoader;
import ru.quadcom.datapack.loaders.impl.NpcLoader;
import ru.quadcom.datapack.services.INPCPack;
import ru.quadcom.datapack.templates.contract.ContractEnemyType;
import ru.quadcom.datapack.templates.contract.ContractNpcDifficulty;
import ru.quadcom.datapack.templates.npc.ClanSuperRewardTemplate;
import ru.quadcom.datapack.templates.npc.HardPvpGroupTemplate;
import ru.quadcom.datapack.templates.npc.HardPvpUnitTemplate;
import ru.quadcom.datapack.templates.npc.NPCGeneration;
import ru.quadcom.datapack.templates.npc.NpcTemplate;
import ru.quadcom.datapack.templates.npc.NpcType;

public class NPCPack
implements INPCPack {
    private final String prefix = "";
    private Map<ContractNpcDifficulty, NPCGeneration> npcGeneration;
    private Map<Integer, NpcTemplate> npc;
    private Map<String, AIClass> aiClasses;
    private Map<String, List<NpcTemplate>> npcsByMissionId;
    private Map<ContractEnemyType, List<HardPvpGroupTemplate>> hardPvpGroupsByNpcType;
    private Map<String, List<HardPvpUnitTemplate>> hardPvpUnitsByGroupId;
    private Map<NpcType, List<NpcTemplate>> npcConfigByNpcType;
    private Map<Integer, List<NpcTemplate>> npcConfigByFractionId;
    private Map<Integer, List<NpcTemplate>> npcConfigAllowedForRandomByFractionId;
    private Map<String, List<ClanSuperRewardTemplate>> clanSuperRewardsByRewardId;

    NPCPack(String resourceUrl) {
        this.npcGeneration = new NPCGenerationLoader(resourceUrl, "").load("npc_generation.json");
        this.npc = new NpcLoader(resourceUrl, "").load("npc.json");
        this.aiClasses = new AIClassLoader(resourceUrl, "").load("ai_classes.json");
        this.npcConfigByNpcType = new HashMap<NpcType, List<NpcTemplate>>();
        for (NpcTemplate npcTemplate : this.npc.values()) {
            if (npcTemplate.getNpcType() == NpcType.NONE) continue;
            if (!this.npcConfigByNpcType.containsKey((Object)npcTemplate.getNpcType())) {
                this.npcConfigByNpcType.put(npcTemplate.getNpcType(), new ArrayList());
            }
            this.npcConfigByNpcType.get((Object)npcTemplate.getNpcType()).add(npcTemplate);
        }
        this.npcConfigByFractionId = new HashMap<Integer, List<NpcTemplate>>();
        this.npcConfigAllowedForRandomByFractionId = new HashMap<Integer, List<NpcTemplate>>();
        for (NpcTemplate template : this.npc.values()) {
            if (!this.npcConfigByFractionId.containsKey(template.getFractionId())) {
                this.npcConfigByFractionId.put(template.getFractionId(), new ArrayList());
            }
            this.npcConfigByFractionId.get(template.getFractionId()).add(template);
            if (!template.isAllowedForRandom()) continue;
            if (!this.npcConfigAllowedForRandomByFractionId.containsKey(template.getFractionId())) {
                this.npcConfigAllowedForRandomByFractionId.put(template.getFractionId(), new ArrayList());
            }
            this.npcConfigAllowedForRandomByFractionId.get(template.getFractionId()).add(template);
        }
        Object hardPvpGroupByDescriptor = new HardPvpGroupsLoader(resourceUrl, "").load("hardpvp_groups.json");
        Object hardPvpUnitsByDescriptor = new HardPvpUnitsLoader(resourceUrl, "").load("hardpvp_units.json");
        this.npcsByMissionId = new HashMap<String, List<NpcTemplate>>();
        this.hardPvpGroupsByNpcType = new HashMap<ContractEnemyType, List<HardPvpGroupTemplate>>();
        for (Object template : hardPvpGroupByDescriptor.values()) {
            if (!this.hardPvpGroupsByNpcType.containsKey((Object)((HardPvpGroupTemplate)template).getUnitsType())) {
                this.hardPvpGroupsByNpcType.put(((HardPvpGroupTemplate)template).getUnitsType(), new ArrayList());
            }
            this.hardPvpGroupsByNpcType.get((Object)((HardPvpGroupTemplate)template).getUnitsType()).add((HardPvpGroupTemplate)template);
        }
        this.hardPvpUnitsByGroupId = new HashMap<String, List<HardPvpUnitTemplate>>();
        for (Object template : hardPvpUnitsByDescriptor.values()) {
            if (!this.hardPvpUnitsByGroupId.containsKey(((HardPvpUnitTemplate)template).getGroupId())) {
                this.hardPvpUnitsByGroupId.put(((HardPvpUnitTemplate)template).getGroupId(), new ArrayList());
            }
            this.hardPvpUnitsByGroupId.get(((HardPvpUnitTemplate)template).getGroupId()).add((HardPvpUnitTemplate)template);
        }
        this.clanSuperRewardsByRewardId = new ClanSuperRewardsLoader(resourceUrl, "").load("clan_super_rewards.json");
    }

    @Override
    public NPCGeneration getGeneration(ContractNpcDifficulty difficulty) {
        return this.npcGeneration.get((Object)difficulty);
    }

    @Override
    public NpcTemplate getNpcTemplate(int id) {
        return this.npc.get(id);
    }

    @Override
    public List<NpcTemplate> getNpcTemplatesByMissionId(String missionId) {
        return this.npcsByMissionId.get(missionId);
    }

    @Override
    public List<HardPvpGroupTemplate> getHardPvpGroupsByType(ContractEnemyType npcType) {
        return this.hardPvpGroupsByNpcType.get((Object)npcType);
    }

    @Override
    public List<HardPvpUnitTemplate> getHardPvpUnitsForGroup(String groupId) {
        return this.hardPvpUnitsByGroupId.get(groupId);
    }

    @Override
    public List<NpcTemplate> getNpcConfigByNpcType(NpcType npcType) {
        return this.npcConfigByNpcType.get((Object)npcType);
    }

    @Override
    public List<NpcTemplate> getNpcConfigByFractionId(int fractionId) {
        return this.npcConfigByFractionId.get(fractionId);
    }

    @Override
    public List<NpcTemplate> getNpcConfigAllowedForRandomByFractionId(int fractionId) {
        return this.npcConfigAllowedForRandomByFractionId.get(fractionId);
    }

    @Override
    public AIClass getAiClass(String classId) {
        return this.aiClasses.get(classId);
    }

    @Override
    public ClanSuperRewardTemplate findClanSuperReward(String rewardId, int buildingLevel, int npcClass) {
        if (rewardId == null) {
            return null;
        }
        return this.clanSuperRewardsByRewardId.get(rewardId).stream().filter(r -> r.getBuildingLevel() == buildingLevel && r.getNpcClass() == npcClass).findFirst().orElse(null);
    }
}

