/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.domains.item;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import ru.quadcom.datapack.domains.item.ItemStat;
import ru.quadcom.datapack.domains.item.ItemStatType;

public class ItemStats {
    private Map<ItemStatType, ItemStat> doubleStats = Maps.newHashMap();

    public Collection<ItemStat> getAllDoubleStats() {
        return this.doubleStats.values();
    }

    public Double getDoubleStat(ItemStatType statType) {
        if (this.doubleStats.containsKey((Object)statType)) {
            return this.doubleStats.get((Object)statType).getValue();
        }
        return statType.getDefaultValue();
    }

    public Integer getDoubleStatAsInt(ItemStatType statType) {
        if (this.doubleStats.containsKey((Object)statType)) {
            return (int)Math.round(this.doubleStats.get((Object)statType).getValue());
        }
        return (int)Math.round(statType.getDefaultValue());
    }

    public void addItemStat(ItemStat itemStat) {
        this.doubleStats.put(itemStat.getStatType(), itemStat);
    }

    public boolean hasItemStat(ItemStatType statType) {
        return this.doubleStats.containsKey((Object)statType);
    }

    public ItemStat getItemStat(ItemStatType statType) {
        return this.doubleStats.get((Object)statType);
    }
}

