/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.domains.identity;

import java.util.UUID;

public class Session {
    private String sessionId;
    private long accountId;
    private long profileId;
    private long timestamp;
    private int rights;

    private Session(long accountId, int rights) {
        this(accountId, 0L, rights);
    }

    private Session(long accountId, long profileId, int rights) {
        this(UUID.randomUUID().toString().replaceAll("-", "_"), accountId, profileId, rights);
    }

    private Session(String sessionId, long accountId, long profileId, int rights) {
        this.sessionId = sessionId;
        this.accountId = accountId;
        this.profileId = profileId;
        this.timestamp = System.currentTimeMillis();
        this.rights = rights;
    }

    public int getRights() {
        return this.rights;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public long getAccountId() {
        return this.accountId;
    }

    public long getProfileId() {
        return this.profileId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public static Session create(long accountId, int rights) {
        return new Session(accountId, rights);
    }

    public static Session create(long accountId, long profileId, int rights) {
        return new Session(accountId, profileId, rights);
    }

    public static Session update(Session session, long profileId) {
        return new Session(session.getSessionId(), session.getAccountId(), profileId, session.getRights());
    }
}

