/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.templates.operator;

import java.util.Collections;
import java.util.Map;
import one.util.streamex.StreamEx;
import ru.quadcom.datapack.common.RandomUtils;

public class AvatarTemplate {
    protected boolean available;
    protected String avatarName;
    protected Map<String, Integer> avatarLayersData;
    protected int sex;
    protected int race;

    public AvatarTemplate(String avatarName, Map<String, Integer> avatarLayersData, int sex, int race) {
        this.avatarName = avatarName;
        this.avatarLayersData = avatarLayersData;
        this.sex = sex;
        this.race = race;
    }

    private AvatarTemplate() {
    }

    public boolean isAvailable() {
        return this.available;
    }

    public String getAvatarName() {
        return this.avatarName;
    }

    public Map<String, Integer> getAvatarLayersData() {
        return Collections.unmodifiableMap(this.avatarLayersData);
    }

    public int getSex() {
        return this.sex;
    }

    public int getRace() {
        return this.race;
    }

    public Map<String, Integer> getNextAvatarLayers() {
        return StreamEx.of(this.avatarLayersData.entrySet()).toMap(Map.Entry::getKey, entry -> RandomUtils.getRandomInt(0, (Integer)entry.getValue() - 1));
    }

    public static MutableAvatarTemplate getBuilder() {
        return new MutableAvatarTemplate();
    }

    public static final class MutableAvatarTemplate
    extends AvatarTemplate {
        public MutableAvatarTemplate setAvailable(boolean available) {
            this.available = available;
            return this;
        }

        public MutableAvatarTemplate setAvatarName(String avatarName) {
            this.avatarName = avatarName;
            return this;
        }

        public MutableAvatarTemplate setAvatarLayersData(Map<String, Integer> avatarLayersData) {
            this.avatarLayersData = avatarLayersData;
            return this;
        }

        public MutableAvatarTemplate setSex(int sex) {
            this.sex = sex;
            return this;
        }

        public MutableAvatarTemplate setRace(int race) {
            this.race = race;
            return this;
        }
    }
}

