/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.services.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import ru.quadcom.datapack.domains.item.ItemType;
import ru.quadcom.datapack.loaders.impl.ItemShopLoader;
import ru.quadcom.datapack.loaders.impl.ItemSpecialShopGroupLoader;
import ru.quadcom.datapack.loaders.impl.ItemSpecialShopLoader;
import ru.quadcom.datapack.loaders.impl.ItemSpecialShopWeightLoader;
import ru.quadcom.datapack.loaders.impl.PVPShopItemLoader;
import ru.quadcom.datapack.services.IShopPack;
import ru.quadcom.datapack.templates.operator.FractionTemplate;
import ru.quadcom.datapack.templates.shop.ItemShopTemplate;
import ru.quadcom.datapack.templates.shop.ItemSpecialShopTemplate;
import ru.quadcom.datapack.templates.shop.ItemSpecialShopWeight;
import ru.quadcom.datapack.templates.shop.PVPShopItemTemplate;

public class ShopPack
implements IShopPack {
    private final String prefix = "";
    private final Map<Integer, Map<Integer, ItemShopTemplate>> itemShop;
    private final Map<Integer, Map<Integer, ItemSpecialShopTemplate>> itemSpecialShop;
    private final NavigableMap<Integer, NavigableMap<Double, ItemType>> itemSpecialShopGroup;
    private final Map<ItemType, NavigableMap<Integer, NavigableMap<Double, ItemSpecialShopWeight>>> itemSpecialShopWeight;
    private final Map<Integer, PVPShopItemTemplate> pvpShopItems;

    public ShopPack(String resourceUrl) {
        this.itemShop = StreamEx.of((Collection)new ItemShopLoader(resourceUrl, "").load("item_shop.json")).groupingBy(ItemShopTemplate::getFractionId, Collectors.toMap(ItemShopTemplate::getItemTemplateId, template -> template));
        this.itemSpecialShop = StreamEx.of((Collection)new ItemSpecialShopLoader(resourceUrl, "").load("item_special_shop.json")).groupingBy(ItemSpecialShopTemplate::getFractionId, Collectors.toMap(ItemSpecialShopTemplate::getItemTemplateId, template -> template));
        this.itemSpecialShopGroup = new ItemSpecialShopGroupLoader(resourceUrl, "").load("item_special_shop_group.json");
        this.itemSpecialShopWeight = new ItemSpecialShopWeightLoader(resourceUrl, "").load("item_special_shop_weight.json");
        this.pvpShopItems = new PVPShopItemLoader(resourceUrl, "").load("pvp_shop.json");
    }

    @Override
    public Map<Integer, ItemShopTemplate> getItemShop(FractionTemplate fractionTemplate) {
        return this.itemShop.get(fractionTemplate.getId());
    }

    @Override
    public Map<Integer, PVPShopItemTemplate> getPVPItemShop() {
        return this.pvpShopItems;
    }

    @Override
    @Deprecated
    public Map<Integer, ItemSpecialShopTemplate> getItemSpecialShop(FractionTemplate fractionTemplate) {
        return this.itemSpecialShop.get(fractionTemplate.getId());
    }

    @Override
    public List<Integer> getSpecialShopItem(int level, int count) {
        HashSet used = Sets.newHashSet();
        ArrayList ids = Lists.newArrayList();
        for (int i = 0; i < ItemType.values().length; ++i) {
            NavigableMap<Double, ItemType> group;
            Map.Entry<Integer, NavigableMap<Double, ItemType>> groupEntry = this.itemSpecialShopGroup.floorEntry(level);
            if (groupEntry != null && (group = groupEntry.getValue()) != null) {
                TreeMap newGroup = Maps.newTreeMap();
                double delta = 0.0;
                double last = 0.0;
                for (Double key : group.navigableKeySet()) {
                    ItemType itemType = (ItemType)((Object)group.get(key));
                    if (!used.contains((Object)itemType)) {
                        newGroup.put(key - delta, itemType);
                    } else {
                        delta += key - last;
                    }
                    last = key;
                }
                Map.Entry typeEntry = newGroup.ceilingEntry(Math.random() * (newGroup.isEmpty() ? 0.0 : (Double)newGroup.lastKey()));
                if (typeEntry != null) {
                    Map.Entry<Double, ItemSpecialShopWeight> idEntry;
                    NavigableMap<Double, ItemSpecialShopWeight> weightsByLevel;
                    Map.Entry<Integer, NavigableMap<Double, ItemSpecialShopWeight>> weightsForLevelEntry;
                    NavigableMap<Integer, NavigableMap<Double, ItemSpecialShopWeight>> weights;
                    ItemType type = (ItemType)((Object)typeEntry.getValue());
                    if (type != null && (weights = this.itemSpecialShopWeight.get((Object)type)) != null && (weightsForLevelEntry = weights.floorEntry(level)) != null && (weightsByLevel = weightsForLevelEntry.getValue()) != null && (idEntry = weightsByLevel.ceilingEntry(Math.random() * (weightsByLevel.isEmpty() ? 0.0 : (Double)weightsByLevel.lastKey()))) != null) {
                        ids.add(idEntry.getValue().getItemTemplateId());
                    }
                    used.add(type);
                }
            }
            if (ids.size() >= count) break;
        }
        return ids;
    }
}

