/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.loaders.impl;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ru.quadcom.datapack.common.RandomValueProvider;
import ru.quadcom.datapack.domains.item.ItemType;
import ru.quadcom.datapack.loaders.Loader;
import ru.quadcom.datapack.templates.common.LootWeight;
import ru.quadcom.datapack.templates.item.ItemTemplate;

public class LootWeightLoader
extends Loader<LootWeight> {
    private final Map<Integer, ItemTemplate> itemTemplates;

    public LootWeightLoader(String resourceUrl, String prefix, Map<Integer, ItemTemplate> itemTemplates) {
        super(resourceUrl, prefix);
        this.itemTemplates = itemTemplates;
    }

    @Override
    protected Type getType() {
        return new TypeToken<List<LootWeight>>(){}.getType();
    }

    @Override
    public Map<ItemType, Map<Integer, RandomValueProvider<ItemTemplate>>> load(String fileName) {
        return this.load0(fileName).stream().flatMap(lw -> lw.getWeights().entrySet().stream().filter(entry -> (Double)entry.getValue() > 0.0).map(Map.Entry::getKey).collect(Collectors.toMap(key -> key, key -> lw)).entrySet().stream()).collect(Collectors.groupingBy(entry -> this.itemTemplates.get(((LootWeight)entry.getValue()).getItemTemplateId()).getItemType(), Collectors.groupingBy(Map.Entry::getKey, Collectors.collectingAndThen(Collectors.toList(), list -> {
            RandomValueProvider<ItemTemplate> rvp = RandomValueProvider.forWeights();
            for (Map.Entry entry : list) {
                int rank = (Integer)entry.getKey();
                LootWeight lw = (LootWeight)entry.getValue();
                double weight = lw.getWeights().get(rank);
                rvp.add(this.itemTemplates.get(lw.getItemTemplateId()), weight);
            }
            return rvp;
        }))));
    }
}

