/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.services.impl;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import ru.quadcom.datapack.common.EnumUtil;
import ru.quadcom.datapack.domains.MissionResult;
import ru.quadcom.datapack.domains.MoneyReward;
import ru.quadcom.datapack.domains.item.ItemActionType;
import ru.quadcom.datapack.domains.item.ItemClass;
import ru.quadcom.datapack.domains.item.ItemTemplatePropertyName;
import ru.quadcom.datapack.domains.item.ItemType;
import ru.quadcom.datapack.loaders.impl.ItemActionsLoader;
import ru.quadcom.datapack.loaders.impl.ItemPropertiesLoader;
import ru.quadcom.datapack.loaders.impl.ItemsLoader;
import ru.quadcom.datapack.loaders.impl.LootBoxSlotGroupLoader;
import ru.quadcom.datapack.loaders.impl.LootBoxSlotItemLoader;
import ru.quadcom.datapack.loaders.impl.LootDrop2Loader;
import ru.quadcom.datapack.loaders.impl.LootDropLoader;
import ru.quadcom.datapack.loaders.impl.LootWeightLoader;
import ru.quadcom.datapack.loaders.impl.MoneyRewardLoader;
import ru.quadcom.datapack.loaders.impl.SkillLoader;
import ru.quadcom.datapack.services.IItemPack;
import ru.quadcom.datapack.templates.item.ItemActionTemplate;
import ru.quadcom.datapack.templates.item.ItemPropertyTemplate;
import ru.quadcom.datapack.templates.item.ItemTemplate;
import ru.quadcom.datapack.templates.item.SkillTemplate;
import ru.quadcom.datapack.templates.lootbox.LootBoxSlotGroup;
import ru.quadcom.datapack.templates.lootbox.LootBoxSlotItem;
import ru.quadcom.exceptions.ErrorException;

public class ItemPack
implements IItemPack {
    private String prefix = "";
    private Map<Integer, ItemTemplate> itemTemplates;
    private Map<Integer, SkillTemplate> skillTemplates;
    private Map<String, SkillTemplate> skillTemplatesByDescriptor;
    private Map<ItemActionType, ItemActionTemplate> itemActionTemplates;
    private Map<Integer, ItemPropertyTemplate> itemPropertyTemplates;
    private Map<String, Map<Integer, NavigableMap<Double, ItemType>>> lootDrops;
    private Map<String, Map<Boolean, Map<Integer, NavigableMap<Double, ItemType>>>> lootDrops2;
    private Map<ItemType, Map<Integer, NavigableMap<Double, Integer>>> lootWeights;
    private Map<Integer, ItemTemplate> ammo;
    private Map<String, Map<MissionResult, Map<Integer, MoneyReward>>> moneyResults;
    private Map<String, List<LootBoxSlotItem>> lootBoxSlotItemsBySlotId;
    private Map<String, List<LootBoxSlotGroup>> lootBoxSlotGroupsById;
    private Map<Integer, ItemTemplate> lootBoxes;

    ItemPack(String resourceUrl) {
        this.itemTemplates = new ItemsLoader(resourceUrl, this.prefix).load("items.json");
        this.itemActionTemplates = new ItemActionsLoader(resourceUrl, this.prefix).load("item_actions.json");
        this.itemPropertyTemplates = new ItemPropertiesLoader(resourceUrl, this.prefix).load("item_properties.json");
        this.skillTemplates = new SkillLoader(resourceUrl, this.prefix).load("skills.json");
        this.skillTemplatesByDescriptor = this.skillTemplates.values().stream().collect(Collectors.toMap(template -> template.getDescriptor().toLowerCase(), Function.identity()));
        this.lootDrops = new LootDropLoader(resourceUrl, this.prefix).load("loot_drops.json");
        this.lootDrops2 = new LootDrop2Loader(resourceUrl, this.prefix).load("loot_drops.json");
        this.lootWeights = new LootWeightLoader(resourceUrl, this.prefix, this.itemTemplates).load("loot_weights.json");
        this.ammo = ((StreamEx)StreamEx.of(this.itemTemplates.values()).filter(template -> template.getItemType() == ItemType.AMMO)).toMap(ItemTemplate::getId, template -> template);
        this.moneyResults = new MoneyRewardLoader(resourceUrl, this.prefix).load("money_rewards.json");
        this.preProcessItemTemplates();
        this.lootBoxSlotItemsBySlotId = new LootBoxSlotItemLoader(resourceUrl, this.prefix).load("lootbox_slot_items.json");
        this.lootBoxSlotGroupsById = new LootBoxSlotGroupLoader(resourceUrl, this.prefix).load("lootbox_slot_groups.json");
        this.lootBoxes = ((StreamEx)StreamEx.of(this.itemTemplates.values()).filter(template -> template.getItemType() == ItemType.LOOTBOX)).toMap(ItemTemplate::getId, template -> template);
    }

    @Override
    public Optional<MoneyReward> getMoneyRewardObject(String rewardName, MissionResult missionResult, int rank) {
        return Optional.ofNullable(this.moneyResults.getOrDefault(rewardName, Maps.newHashMap()).getOrDefault((Object)missionResult, Maps.newHashMap()).get(rank));
    }

    @Override
    public int getMoneyReward(String rewardName, MissionResult missionResult, int rank) {
        return this.getMoneyRewardObject(rewardName, missionResult, rank).map(MoneyReward::getMoneyValue).orElse(0);
    }

    @Override
    public Optional<ItemTemplate> getDefaultAmmo(ItemTemplate weapon) {
        if (weapon.getItemType() != ItemType.WEAPON) {
            throw new ErrorException("Wrong item type " + (Object)((Object)weapon.getItemType()));
        }
        return ((StreamEx)((StreamEx)((StreamEx)StreamEx.of(this.ammo.values()).filter(template -> template.getBooleanItemTemplateProperty(ItemTemplatePropertyName.defaultammo))).filter(template -> template.getBooleanItemTemplateProperty(ItemTemplatePropertyName.batterytype) == weapon.getBooleanItemTemplateProperty(ItemTemplatePropertyName.rayweapon))).filter(template -> {
            if (weapon.getBooleanItemTemplateProperty(ItemTemplatePropertyName.rayweapon)) {
                return true;
            }
            String weapontype = template.getStringItemTemplateProperty(ItemTemplatePropertyName.weapontype);
            return Strings.isNullOrEmpty((String)weapontype) || EnumUtil.lookup(ItemClass.class, weapontype) == weapon.getItemClass();
        })).findFirst();
    }

    @Override
    public List<ItemTemplate> getItemTemplates() {
        return Lists.newArrayList(this.itemTemplates.values());
    }

    @Override
    public Optional<ItemTemplate> getItemTemplateOptional(int itemTemplateId) {
        return Optional.ofNullable(this.itemTemplates.get(itemTemplateId));
    }

    @Override
    public ItemTemplate getItemTemplate(int id) {
        ItemTemplate template = this.itemTemplates.get(id);
        if (template == null) {
            throw new ErrorException("not fount template for item with id = " + id);
        }
        return template;
    }

    @Override
    public SkillTemplate getSkillTemplate(String descriptor) {
        SkillTemplate template = this.skillTemplatesByDescriptor.get(descriptor.toLowerCase());
        if (template == null) {
            throw new ErrorException("not fount template for skill with descriptor=" + descriptor);
        }
        return template;
    }

    @Override
    public SkillTemplate getSkillTemplate(int id) {
        SkillTemplate template = this.skillTemplates.get(id);
        if (template == null) {
            throw new ErrorException("not fount template for skill with id = " + id);
        }
        return template;
    }

    @Override
    public Optional<SkillTemplate> getSkillTemplateOptional(int skillTemplateId) {
        return Optional.ofNullable(this.skillTemplates.get(skillTemplateId));
    }

    @Override
    public List<SkillTemplate> getSkills() {
        return Lists.newArrayList(this.skillTemplates.values());
    }

    @Override
    public ItemActionTemplate getItemActionTemplate(ItemActionType itemActionType) {
        return this.itemActionTemplates.get((Object)itemActionType);
    }

    @Override
    public ItemPropertyTemplate getItemPropertyTemplate(int itemPropertyTemplateId) {
        return this.itemPropertyTemplates.get(itemPropertyTemplateId);
    }

    @Override
    @Deprecated
    public List<ItemTemplate> generateDrop(String dropListName, int rank, int count) {
        ArrayList drop = Lists.newArrayList();
        for (int i = 0; i < count; ++i) {
            ItemTemplate itemTemplate;
            ItemType itemType;
            NavigableMap<Double, Integer> map2;
            Double key2;
            NavigableMap<Double, ItemType> map = this.lootDrops.getOrDefault(dropListName, Maps.newHashMap()).getOrDefault(rank, Maps.newTreeMap());
            Double key = map.ceilingKey(Math.random());
            if (key == null || (key2 = (map2 = this.lootWeights.getOrDefault((Object)(itemType = (ItemType)((Object)map.get(key))), Maps.newHashMap()).getOrDefault(rank, Maps.newTreeMap())).ceilingKey(Math.random())) == null || (itemTemplate = this.itemTemplates.get(map2.get(key2))) == null) continue;
            drop.add(itemTemplate);
        }
        return drop;
    }

    @Override
    public List<ItemTemplate> generateDrop(String dropListName, boolean win, int rank, int count) {
        ArrayList drop = Lists.newArrayList();
        for (int i = 0; i < count; ++i) {
            ItemTemplate itemTemplate;
            ItemType itemType;
            NavigableMap<Double, Integer> map2;
            Double key2;
            NavigableMap<Double, ItemType> map = this.lootDrops2.getOrDefault(dropListName, Maps.newHashMap()).getOrDefault(win, Maps.newHashMap()).getOrDefault(rank, Maps.newTreeMap());
            Double key = map.ceilingKey(Math.random());
            if (key == null || (key2 = (map2 = this.lootWeights.getOrDefault((Object)(itemType = (ItemType)((Object)map.get(key))), Maps.newHashMap()).getOrDefault(rank, Maps.newTreeMap())).ceilingKey(Math.random())) == null || (itemTemplate = this.itemTemplates.get(map2.get(key2))) == null) continue;
            drop.add(itemTemplate);
        }
        return drop;
    }

    @Override
    public List<LootBoxSlotItem> getLootBoxSlotItemsBySlotId(String slotId) {
        return this.lootBoxSlotItemsBySlotId.get(slotId);
    }

    @Override
    public List<LootBoxSlotGroup> getLootBoxSlotGroupsById(String groupId) {
        return this.lootBoxSlotGroupsById.get(groupId);
    }

    private void preProcessItemTemplates() {
        for (ItemTemplate itemTemplate : this.itemTemplates.values()) {
            itemTemplate.preProcess();
        }
        for (ItemTemplate itemTemplate : this.skillTemplates.values()) {
            itemTemplate.preProcess();
        }
    }
}

