/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.services.impl;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import one.util.streamex.StreamEx;
import ru.quadcom.datapack.loaders.impl.ContractGroupLoader;
import ru.quadcom.datapack.loaders.impl.ContractLoader;
import ru.quadcom.datapack.loaders.impl.MapGroupLoader;
import ru.quadcom.datapack.loaders.impl.NPCGroupLoader;
import ru.quadcom.datapack.services.IContractPack;
import ru.quadcom.datapack.templates.MapGroup;
import ru.quadcom.datapack.templates.contract.ContractGroup;
import ru.quadcom.datapack.templates.contract.ContractTemplate;
import ru.quadcom.datapack.templates.npc.NpcGroup;

public class ContractPack
implements IContractPack {
    private final String prefix = "";
    private final Map<Integer, ContractTemplate> contracts;
    private final Map<String, ContractTemplate> contractsByDescriptor;
    private final Map<String, List<MapGroup>> mapGroupsByMapGroupId;
    private final Map<String, MapGroup> mapGroupsById;
    private final Map<String, NavigableMap<Double, ContractGroup>> contractGroups;
    private final Map<String, List<NpcGroup>> npcGroupByNpcGroupId;
    private static final Random random = new Random();

    public ContractPack(String resourceUrl) {
        this.contracts = new ContractLoader(resourceUrl, "").load("contracts.json");
        this.contractsByDescriptor = StreamEx.of(this.contracts.values()).toMap(ContractTemplate::getDescriptor, Function.identity());
        this.mapGroupsByMapGroupId = new MapGroupLoader(resourceUrl, "").load("map_groups.json");
        this.mapGroupsById = new HashMap<String, MapGroup>();
        for (List<MapGroup> list : this.mapGroupsByMapGroupId.values()) {
            for (MapGroup group : list) {
                this.mapGroupsById.put(group.getId(), group);
            }
        }
        this.contractGroups = new ContractGroupLoader(resourceUrl, "").load("contract_groups.json");
        this.npcGroupByNpcGroupId = new NPCGroupLoader(resourceUrl, "").load("npc_groups.json");
    }

    @Override
    public ContractTemplate getContractTemplate(int contractTemplateId) {
        return this.contracts.get(contractTemplateId);
    }

    @Override
    public ContractTemplate getContractTemplate(String descriptor) {
        return this.contractsByDescriptor.get(descriptor);
    }

    @Override
    public Collection<ContractTemplate> getAll() {
        return Collections.unmodifiableCollection(this.contracts.values());
    }

    @Override
    public Map<Integer, ContractTemplate> getAllAsMap() {
        return Maps.newHashMap(this.contracts);
    }

    @Override
    public List<MapGroup> getMapGroups(String mapGroupId) {
        return this.mapGroupsByMapGroupId.get(mapGroupId);
    }

    @Override
    public MapGroup getMapGroup(String id) {
        return this.mapGroupsById.get(id);
    }

    @Override
    public List<NpcGroup> getNpcGroups(String id) {
        return this.npcGroupByNpcGroupId.get(id);
    }

    @Override
    public Optional<ContractTemplate> getRandomContractTemplateByGroupId(String groupId) {
        return Optional.ofNullable(this.contractGroups.get(groupId)).map(map -> map.ceilingEntry((Double)map.lastKey() * random.nextDouble())).map(entry -> this.contracts.get(((ContractGroup)entry.getValue()).getContractId()));
    }
}

