/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.services.impl;

import java.util.Collection;
import java.util.Map;
import ru.quadcom.datapack.loaders.impl.BuildingsLoader;
import ru.quadcom.datapack.loaders.impl.ResearchesLoader;
import ru.quadcom.datapack.services.IBasePack;
import ru.quadcom.datapack.templates.base.BuildingTemplate;
import ru.quadcom.datapack.templates.base.BuildingType;
import ru.quadcom.datapack.templates.base.ResearchTemplate;

public class BasePack
implements IBasePack {
    private final Map<BuildingType, Map<Integer, Map<Integer, BuildingTemplate>>> buildings;
    private final Map<Integer, ResearchTemplate> researches;

    BasePack(String resourceUrl) {
        this.buildings = new BuildingsLoader(resourceUrl).load("buildings.json");
        this.researches = new ResearchesLoader(resourceUrl).load("researches.json");
    }

    @Override
    public Map<Integer, BuildingTemplate> getBuildingTemplate(BuildingType type, int level) {
        return this.buildings.get((Object)type).get(level);
    }

    @Override
    public ResearchTemplate getResearch(int templateId) {
        return this.researches.get(templateId);
    }

    @Override
    public Collection<ResearchTemplate> getResearches() {
        return this.researches.values();
    }
}

