/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.services.impl;

import java.util.List;
import java.util.Map;
import ru.quadcom.datapack.domains.item.ItemActionType;
import ru.quadcom.datapack.domains.item.ItemStack;
import ru.quadcom.datapack.loaders.impl.ItemActionsLoader;
import ru.quadcom.datapack.loaders.impl.ItemPropertiesLoader;
import ru.quadcom.datapack.loaders.impl.ItemsLoader;
import ru.quadcom.datapack.services.IItemPack;
import ru.quadcom.datapack.templates.item.ClassDefaultItemsTemplate;
import ru.quadcom.datapack.templates.item.ItemActionTemplate;
import ru.quadcom.datapack.templates.item.ItemPropertyTemplate;
import ru.quadcom.datapack.templates.item.ItemTemplate;

public class ItemPack
implements IItemPack {
    private String prefix = "";
    private Map<Integer, ItemTemplate> itemTemplates;
    private Map<ItemActionType, ItemActionTemplate> itemActionTemplates;
    private Map<Integer, ItemPropertyTemplate> itemPropertyTemplates;
    private Map<String, ClassDefaultItemsTemplate> classDefaultItemsTemplates;
    private List<ItemStack> profileDefaultInventory;

    ItemPack(String resourceUrl) {
        this.itemTemplates = new ItemsLoader(resourceUrl, this.prefix).load("items.json");
        this.itemActionTemplates = new ItemActionsLoader(resourceUrl, this.prefix).load("item_actions.json");
        this.itemPropertyTemplates = new ItemPropertiesLoader(resourceUrl, this.prefix).load("item_properties.json");
        this.preProcessItemTemplates();
    }

    @Override
    public ItemTemplate getItemTemplate(int itemTemplateId) {
        return this.itemTemplates.get(itemTemplateId);
    }

    @Override
    public ItemActionTemplate getItemActionTemplate(ItemActionType itemActionType) {
        return this.itemActionTemplates.get((Object)itemActionType);
    }

    @Override
    public ItemPropertyTemplate getItemPropertyTemplate(int itemPropertyTemplateId) {
        return this.itemPropertyTemplates.get(itemPropertyTemplateId);
    }

    @Override
    public ClassDefaultItemsTemplate getClassDefaultItemsTemplate(int classId, int rarityId) {
        return this.classDefaultItemsTemplates.get(classId + ":" + rarityId);
    }

    @Override
    public List<ItemStack> getProfileDefaultInventory() {
        return this.profileDefaultInventory;
    }

    private void preProcessItemTemplates() {
        for (ItemTemplate itemTemplate : this.itemTemplates.values()) {
            itemTemplate.preProcess();
        }
    }
}

