/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.dbtool.authactions;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.typesafe.config.Config;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import play.mvc.Action;
import play.mvc.Http;
import play.mvc.Result;
import ru.quadcom.dbtool.AbstractBaseController;
import ru.quadcom.dbtool.authactions.AuthorizeWithPassword;
import ru.quadcom.dbtool.authactions.MD5;
import ru.quadcom.prototool.gateway.ILoggerService;

public class AuthorizeWithPasswordAction
extends Action<AuthorizeWithPassword> {
    @Inject
    private static Config config;
    @Inject
    private static ILoggerService loggerService;
    private static final String PARAM_SIGNATURE = "signature";
    private static final String PARAM_TIMESTAMP = "timestamp";

    public CompletionStage<Result> call(Http.Context ctx) {
        Map<String, String> paramsMap = AuthorizeWithPasswordAction.getParamsMap(ctx);
        if (!AuthorizeWithPasswordAction.isValidSignature(paramsMap)) {
            return CompletableFuture.completedFuture(AuthorizeWithPasswordAction.badRequest((String)"Wrong signature"));
        }
        if (!AuthorizeWithPasswordAction.isValidTimestamp(paramsMap)) {
            return CompletableFuture.completedFuture(AuthorizeWithPasswordAction.badRequest((String)"Expired timestamp"));
        }
        CompletionStage result = this.delegate.call(ctx);
        result.whenCompleteAsync((result1, throwable) -> {
            boolean needLog;
            if (throwable == null && (needLog = ((AuthorizeWithPassword)this.configuration).log())) {
                String accountId = (String)paramsMap.remove("accountId");
                String profileId = (String)paramsMap.remove("profileId");
                paramsMap.remove(PARAM_SIGNATURE);
                loggerService.addCustomEvent(Strings.isNullOrEmpty((String)accountId) ? 0L : Long.parseLong(accountId), Strings.isNullOrEmpty((String)profileId) ? 0L : Long.parseLong(profileId), "Admin#" + ((AuthorizeWithPassword)this.configuration).name(), paramsMap);
            }
        });
        return result;
    }

    private static Map<String, String> getParamsMap(Http.Context ctx) {
        Map<String, String[]> paramsIntermediate = AbstractBaseController.getRequestParameters(ctx.request());
        HashMap result = Maps.newHashMap();
        for (Map.Entry<String, String[]> entry : paramsIntermediate.entrySet()) {
            String[] param = entry.getValue();
            String value = param == null || param.length == 0 ? "" : param[0];
            result.put(entry.getKey(), value);
        }
        return result;
    }

    private static boolean isValidSignature(Map<String, String> paramsMap) {
        String signatureFromRequest = paramsMap.get(PARAM_SIGNATURE);
        if (Strings.isNullOrEmpty((String)signatureFromRequest)) {
            return false;
        }
        ArrayList<String> sortedKeys = new ArrayList<String>(paramsMap.keySet());
        sortedKeys.remove(PARAM_SIGNATURE);
        Collections.sort(sortedKeys);
        StringBuilder keyValueString = new StringBuilder(128);
        for (String key : sortedKeys) {
            String value = paramsMap.get(key);
            keyValueString.append(key).append('=').append(value);
        }
        keyValueString.append(config.getString("configuration.secret"));
        String expectedSign = MD5.Do(keyValueString.toString());
        return expectedSign.equals(signatureFromRequest);
    }

    private static boolean isValidTimestamp(Map<String, String> paramsMap) {
        long timestampFromRequest;
        String timestampStringFromRequest = paramsMap.get(PARAM_TIMESTAMP);
        if (Strings.isNullOrEmpty((String)timestampStringFromRequest)) {
            return false;
        }
        try {
            timestampFromRequest = Long.parseLong(timestampStringFromRequest);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        long limitDeltaTimestampSec = 3600L;
        long currentUnixTime = System.currentTimeMillis() / 1000L;
        return Math.abs(timestampFromRequest - currentUnixTime) <= 3600L;
    }
}

