/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.dbtool.authactions;

import com.google.inject.Inject;
import java.util.concurrent.CompletionStage;
import play.mvc.Action;
import play.mvc.Http;
import play.mvc.Result;
import ru.quadcom.datapack.domains.identity.Session;
import ru.quadcom.dbtool.AbstractBaseController;
import ru.quadcom.dbtool.ISessionInMemoryCache;
import ru.quadcom.dbtool.authactions.AuthorizeWithProfile;
import ru.quadcom.exceptions.FatalErrorException;

public class AuthorizeWithProfileAction
extends Action<AuthorizeWithProfile> {
    @Inject
    private static ISessionInMemoryCache sessionInMemoryCache;

    public CompletionStage<Result> call(Http.Context ctx) {
        String sessionId = AbstractBaseController.getTokenString(ctx.request());
        if (sessionId == null) {
            throw new FatalErrorException("Missing access token");
        }
        Session session = sessionInMemoryCache.getSession(sessionId);
        if (session.getAccountId() > 0L) {
            if (session.getProfileId() > 0L) {
                return this.saveSessionToContext(session, ctx);
            }
            sessionInMemoryCache.invalidate(session.getSessionId());
            session = sessionInMemoryCache.getSession(sessionId);
            if (session.getAccountId() > 0L && session.getProfileId() > 0L) {
                return this.saveSessionToContext(session, ctx);
            }
        }
        throw new FatalErrorException("Session corrupted");
    }

    private CompletionStage<Result> saveSessionToContext(Session session, Http.Context ctx) {
        ctx.args.put("session", session);
        return this.delegate.call(ctx);
    }
}

