/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.dbtool.cache;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.lettuce.core.Value;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import one.util.streamex.LongStreamEx;
import one.util.streamex.StreamEx;
import play.inject.ApplicationLifecycle;
import ru.quadcom.dbtool.AbstractRedisService;
import ru.quadcom.dbtool.cache.ICache;
import scala.concurrent.ExecutionContextExecutor;

public abstract class AbstractCache<T>
extends AbstractRedisService
implements ICache<T> {
    private final Gson gson = new GsonBuilder().create();
    private final long expireTime;

    public AbstractCache(String url, ApplicationLifecycle applicationLifecycle, ExecutionContextExecutor executionContext, long expireTime) {
        super(url, applicationLifecycle, executionContext);
        this.expireTime = Math.max(60L, expireTime);
    }

    @Override
    public CompletionStage<Optional<T>> get(long entityId) {
        return this.supply(commands -> Optional.ofNullable(commands.get((Object)this.getKey(entityId))).map(json -> {
            Type type = this.getType();
            return this.gson.fromJson(json, type);
        }));
    }

    @Override
    public CompletionStage<Map<Long, T>> getAll(long ownerId) {
        return this.getIds(ownerId).thenCompose(ids -> this.supply(commands -> {
            List result = commands.mget(StreamEx.of((Collection)ids).map(String::valueOf).toArray(String.class));
            return ((StreamEx)StreamEx.of((Collection)result).filter(Value::hasValue)).map(kv -> {
                Type type = this.getType();
                String json = (String)kv.getValue();
                return this.gson.fromJson(json, type);
            }).toMap(this::getId, entity -> entity);
        }));
    }

    @Override
    public CompletionStage<Void> store(T entity) {
        return this.supply(commands -> {
            long id = this.getId(entity);
            String key = this.getKey(id);
            Type type = this.getType();
            commands.setex((Object)key, this.expireTime, (Object)this.gson.toJson(entity, type));
            return null;
        });
    }

    @Override
    public CompletionStage<Set<Long>> getIds(long ownerId) {
        String ownerKey = this.getOwnerKey(ownerId);
        return this.supply(commands -> StreamEx.ofNullable((Object)commands.smembers((Object)ownerKey)).flatMap(StreamEx::of).map(Long::valueOf).toSet());
    }

    @Override
    public CompletionStage<Void> storeIds(long ownerId, Set<Long> entityIds) {
        return this.supply(commands -> {
            String ownerKey = this.getOwnerKey(ownerId);
            commands.sadd((Object)ownerKey, LongStreamEx.of((Collection)entityIds).mapToObj(String::valueOf).toArray(String.class));
            commands.expire((Object)ownerKey, this.expireTime);
            return null;
        });
    }

    @Override
    public CompletionStage<Void> remove(long ownerId, long entityId) {
        return this.supply(commands -> {
            commands.del((Object[])new String[]{this.getKey(entityId)});
            commands.srem((Object)this.getOwnerKey(ownerId), (Object[])new String[]{String.valueOf(entityId)});
            return null;
        });
    }

    @Override
    public CompletionStage<Void> storeId(long ownerId, long entityId) {
        return this.supply(commands -> {
            String ownerKey = this.getOwnerKey(ownerId);
            commands.sadd((Object)ownerKey, (Object[])new String[]{String.valueOf(entityId)});
            commands.expire((Object)ownerKey, this.expireTime);
            return null;
        });
    }

    protected abstract Type getType();

    protected abstract String getKey(long var1);

    protected abstract String getOwnerKey(long var1);

    protected abstract Long getId(T var1);
}

