/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.dbtool.authactions;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.typesafe.config.Config;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import play.mvc.Action;
import play.mvc.Http;
import play.mvc.Result;
import ru.quadcom.dbtool.AbstractBaseController;
import ru.quadcom.dbtool.authactions.AuthorizeWithPassword;
import ru.quadcom.prototool.gateway.ILoggerService;

public class AuthorizeWithPasswordAction
extends Action<AuthorizeWithPassword> {
    @Inject
    private static Config config;
    @Inject
    private static ILoggerService loggerService;

    public CompletionStage<Result> call(Http.Context ctx) {
        try {
            if (this.isValidateSecretKey()) {
                CompletionStage result = this.delegate.call(ctx);
                result.whenCompleteAsync((result1, throwable) -> {
                    boolean log;
                    if (throwable == null && (log = ((AuthorizeWithPassword)this.configuration).log())) {
                        String name = ((AuthorizeWithPassword)this.configuration).name();
                        Map<String, String[]> params = AbstractBaseController.getRequestParameters(ctx.request());
                        HashMap resMap = Maps.newHashMap();
                        for (Map.Entry<String, String[]> entry : params.entrySet()) {
                            String[] param = entry.getValue();
                            String value = param == null || param.length == 0 ? "" : param[0];
                            resMap.put(entry.getKey(), value);
                        }
                        String accountId = (String)resMap.remove("accountId");
                        String profileId = (String)resMap.remove("profileId");
                        loggerService.addCustomEvent(Strings.isNullOrEmpty((String)accountId) ? 0L : Long.valueOf(accountId), Strings.isNullOrEmpty((String)profileId) ? 0L : Long.valueOf(profileId), "Admin#" + name, (Map)resMap);
                    }
                });
                return result;
            }
        }
        catch (NoSuchAlgorithmException e) {
            return CompletableFuture.completedFuture(AuthorizeWithPasswordAction.badRequest((String)"Error check signature"));
        }
        return CompletableFuture.completedFuture(AuthorizeWithPasswordAction.badRequest((String)"Wrong signature"));
    }

    private boolean isValidateSecretKey() throws NoSuchAlgorithmException {
        String key = AbstractBaseController.getRequiredOrEmptyParameter("key");
        String who = AbstractBaseController.getRequiredOrEmptyParameter("who");
        MessageDigest md = MessageDigest.getInstance("MD5");
        BigInteger bigInt = new BigInteger(1, md.digest((who + config.getString("configuration.secret")).getBytes()));
        String md5Hex = bigInt.toString(16);
        return md5Hex.equals(key);
    }
}

