/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.dbtool;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.lettuce.core.pubsub.RedisPubSubListener;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import ru.quadcom.commons.exceptions.ServiceException;
import ru.quadcom.datapack.domains.identity.Session;
import ru.quadcom.dbtool.IRedisChannelService;
import ru.quadcom.dbtool.ISessionInMemoryCache;
import ru.quadcom.dbtool.RedisChannel;
import ru.quadcom.dbtool.redislisteners.SessionListener;
import ru.quadcom.prototool.gateway.ISessionProvider;

public abstract class SessionInMemoryCache
implements ISessionInMemoryCache {
    private final LoadingCache<String, Session> cache;

    public SessionInMemoryCache(IRedisChannelService redisChannelService, final ISessionProvider sessionProvider) {
        this.cache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, Session>(){

            public Session load(String sessionId) throws ExecutionException, InterruptedException {
                return (Session)sessionProvider.getSession(sessionId).toCompletableFuture().get();
            }
        });
        redisChannelService.subscribe(RedisChannel.SESSION_ALL, (RedisPubSubListener<String, String>)new SessionListener(this, RedisChannel.SESSION_ALL));
    }

    @Override
    public Session getSession(String sessionId) {
        try {
            Session session = (Session)this.cache.get((Object)sessionId);
            if (session == null) {
                throw new ServiceException("Session not found", null);
            }
            return session;
        }
        catch (ExecutionException e) {
            throw new ServiceException("Session not found", (Throwable)e, null);
        }
    }

    @Override
    public void invalidate(String sessionId) {
        this.cache.invalidate((Object)sessionId);
    }

    @Override
    public void put(Session session) {
        this.cache.put((Object)session.getSessionId(), (Object)session);
    }
}

