/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.dbtool;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.async.RedisAsyncCommands;
import io.lettuce.core.api.sync.RedisCommands;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import play.inject.ApplicationLifecycle;
import ru.quadcom.commons.exceptions.ServiceException;
import ru.quadcom.dbtool.AbstractPubSubService;
import ru.quadcom.dbtool.IRedisCacheService;
import scala.concurrent.ExecutionContextExecutor;

public abstract class AbstractRedisService
extends AbstractPubSubService
implements IRedisCacheService {
    private final ExecutionContextExecutor executionContext;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public AbstractRedisService(String url, ApplicationLifecycle applicationLifecycle, ExecutionContextExecutor executionContext) {
        super(url, applicationLifecycle);
        this.executionContext = executionContext;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> CompletableFuture<T> supply(Function<RedisCommands<String, String>, T> function) {
        try (StatefulRedisConnection connection = (StatefulRedisConnection)this.getPool().borrowObject();){
            RedisCommands commands = connection.sync();
            CompletableFuture<RedisCommands<String, String>> completableFuture = CompletableFuture.completedFuture(function.apply((RedisCommands<String, String>)commands));
            return completableFuture;
        }
        catch (Exception e) {
            throw new ServiceException("Error supply redis commands", (Throwable)e, null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> CompletableFuture<T> async(Function<RedisAsyncCommands<String, String>, T> function) {
        try (StatefulRedisConnection connection = (StatefulRedisConnection)this.getPool().borrowObject();){
            RedisAsyncCommands commands = connection.async();
            CompletableFuture<Object> completableFuture = CompletableFuture.supplyAsync(() -> function.apply(commands), (Executor)this.executionContext);
            return completableFuture;
        }
        catch (Exception e) {
            throw new ServiceException("Error supply redis commands", (Throwable)e, null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CompletableFuture<Void> run(Consumer<RedisCommands<String, String>> consumer) {
        try (StatefulRedisConnection connection = (StatefulRedisConnection)this.getPool().borrowObject();){
            RedisCommands commands = connection.sync();
            CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> consumer.accept(commands), (Executor)this.executionContext);
            return completableFuture;
        }
        catch (Exception e) {
            throw new ServiceException("Error run redis commands", (Throwable)e, null);
        }
    }

    @Override
    public <T> String getKey(Class<T> clazz, String id) {
        return clazz.getSimpleName() + ":" + id;
    }

    @Override
    @Deprecated
    public <T> String getKey(Class<T> clazz, long id) {
        return this.getKey(clazz, String.valueOf(id));
    }

    @Override
    public String toJson(Object object) {
        return this.gson.toJson(object);
    }

    @Override
    public <T> T fromJson(String json, Class<T> classOfT) {
        return (T)this.gson.fromJson(json, classOfT);
    }

    @Override
    protected void matcher(AbstractPubSubService.Matcher matcher) {
    }
}

