/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.dbtool;

import com.google.common.collect.Maps;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.pubsub.RedisPubSubAdapter;
import io.lettuce.core.pubsub.RedisPubSubListener;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import io.lettuce.core.pubsub.api.sync.RedisPubSubCommands;
import io.lettuce.core.support.ConnectionPoolSupport;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import play.inject.ApplicationLifecycle;
import ru.quadcom.commons.exceptions.ServiceException;
import ru.quadcom.dbtool.IRedisChannel;
import ru.quadcom.dbtool.IRedisChannelService;
import ru.quadcom.dbtool.RedisChannel;
import ru.quadcom.dbtool.redismessages.IRedisMessage;

public abstract class AbstractPubSubService
implements IRedisChannelService {
    private final GenericObjectPool<StatefulRedisPubSubConnection<String, String>> subPool;
    private final GenericObjectPool<StatefulRedisConnection<String, String>> pool;

    public AbstractPubSubService(String url, ApplicationLifecycle applicationLifecycle) {
        RedisURI uri = RedisURI.create((String)url);
        RedisClient client = RedisClient.create((RedisURI)uri);
        this.subPool = ConnectionPoolSupport.createGenericObjectPool(() -> ((RedisClient)client).connectPubSub(), (GenericObjectPoolConfig)new GenericObjectPoolConfig());
        this.pool = ConnectionPoolSupport.createGenericObjectPool(() -> ((RedisClient)client).connect(), (GenericObjectPoolConfig)new GenericObjectPoolConfig());
        applicationLifecycle.addStopHook(() -> CompletableFuture.runAsync(() -> {
            this.subPool.close();
            this.pool.close();
            client.shutdown();
        }));
        this.subscribe();
    }

    @Override
    @Deprecated
    public void subscribe(IRedisChannel channel, RedisPubSubListener<String, String> listener) {
        try (StatefulRedisPubSubConnection connection = (StatefulRedisPubSubConnection)this.subPool.borrowObject();){
            connection.addListener(listener);
            RedisPubSubCommands commands = connection.sync();
            commands.subscribe((Object[])new String[]{channel.getChannelName()});
        }
        catch (Exception e) {
            throw new ServiceException("Error subscribe redis commands", (Throwable)e, null);
        }
    }

    private void subscribe() {
        try (StatefulRedisPubSubConnection connection = (StatefulRedisPubSubConnection)this.subPool.borrowObject();){
            final Matcher matcher = new Matcher();
            this.matcher(matcher);
            connection.addListener((RedisPubSubListener)new RedisPubSubAdapter<String, String>(){

                public void message(String channelName, String message) {
                    RedisChannel channel = RedisChannel.getByName(channelName);
                    Consumer handler = (Consumer)matcher.handlers.get(channel);
                    handler.accept(message);
                }
            });
            for (IRedisChannel channel : matcher.handlers.keySet()) {
                RedisPubSubCommands commands = connection.sync();
                commands.subscribe((Object[])new String[]{channel.getChannelName()});
            }
        }
        catch (Exception e) {
            throw new ServiceException("Error subscribe redis commands", (Throwable)e, null);
        }
    }

    private boolean match(RedisChannel channel, String name) {
        return channel.getChannelName().equalsIgnoreCase(name);
    }

    protected abstract void matcher(Matcher var1);

    @Override
    public void publish(IRedisChannel channel, IRedisMessage message) {
        try (StatefulRedisConnection connection = (StatefulRedisConnection)this.pool.borrowObject();){
            RedisCommands commands = connection.sync();
            commands.publish((Object)channel.getChannelName(), (Object)message.toJson());
        }
        catch (Exception e) {
            throw new ServiceException("Error publish redis commands", (Throwable)e, null);
        }
    }

    protected GenericObjectPool<StatefulRedisConnection<String, String>> getPool() {
        return this.pool;
    }

    public static final class Matcher {
        private final Map<RedisChannel, Consumer<String>> handlers = Maps.newHashMap();

        public Matcher match(RedisChannel channel, Consumer<String> handler) {
            this.handlers.put(channel, handler);
            return this;
        }
    }
}

