/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.dbtool.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import ru.quadcom.dbtool.cache.IInMemoryCache;
import ru.quadcom.exceptions.ErrorException;

public abstract class AbstractInMemoryCache<K1, K2, V>
implements IInMemoryCache<K1, K2, V> {
    private final LoadingCache<K1, Map<K2, V>> cache;
    private final Function<V, K2> entityIdGetter;

    protected AbstractInMemoryCache(int expireTimeSeconds, final Function<K1, Map<K2, V>> loader, Function<V, K2> entityIdGetter) {
        this.cache = CacheBuilder.newBuilder().expireAfterAccess((long)expireTimeSeconds, TimeUnit.SECONDS).build(new CacheLoader<K1, Map<K2, V>>(){

            public Map<K2, V> load(K1 key) {
                Map map = (Map)loader.apply(key);
                if (map == null) {
                    map = Maps.newHashMap();
                }
                return map;
            }
        });
        this.entityIdGetter = entityIdGetter;
    }

    @Override
    public Optional<V> get(K1 ownerId, K2 entityId) {
        Map<K2, V> map = this.getMap(ownerId);
        return Optional.ofNullable(map.get(entityId));
    }

    @Override
    public List<V> getAll(K1 ownerId) {
        Map<K2, V> map = this.getMap(ownerId);
        return Lists.newArrayList(map.values());
    }

    @Override
    public V store(K1 ownerId, V entity) {
        Map<K2, V> map = this.getMap(ownerId);
        K2 entityId = this.entityIdGetter.apply(entity);
        return map.put(entityId, entity);
    }

    @Override
    public V remove(K1 ownerId, K2 entityId) {
        Map<K2, V> map = this.getMap(ownerId);
        return map.remove(entityId);
    }

    private Map<K2, V> getMap(K1 ownerId) {
        try {
            return (Map)this.cache.get(ownerId);
        }
        catch (ExecutionException e) {
            throw new ErrorException("Error load object in cache " + this.getClass(), (Throwable)e);
        }
    }
}

