/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.dbtool;

import com.google.common.collect.Lists;
import com.typesafe.config.Config;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import one.util.streamex.StreamEx;
import play.db.jpa.JPAApi;
import ru.quadcom.commons.exceptions.ServiceException;
import scala.concurrent.ExecutionContextExecutor;

public abstract class AbstractRepository {
    private final ExecutionContextExecutor executionContextExecutor;
    private final JPAApi jpaApi;
    private final String last;
    private final String first;
    private final List<String> DBNames;
    private final long shardSize = 1000000000000L;

    public AbstractRepository(ExecutionContextExecutor executionContextExecutor, JPAApi jpaApi, Config config) {
        this.executionContextExecutor = executionContextExecutor;
        this.jpaApi = jpaApi;
        this.last = ((Integer)StreamEx.of((Collection)config.getConfig("jpa").entrySet()).map(Map.Entry::getKey).map(Integer::valueOf).max(Comparator.comparingInt(x -> x)).orElseThrow(() -> new ServiceException("JPA name not configured"))).toString();
        this.first = ((Integer)StreamEx.of((Collection)config.getConfig("jpa").entrySet()).map(Map.Entry::getKey).map(Integer::valueOf).min(Comparator.comparingInt(x -> x)).orElseThrow(() -> new ServiceException("JPA name not configured"))).toString();
        this.DBNames = Collections.unmodifiableList(StreamEx.of((Collection)config.getConfig("jpa").entrySet()).map(Map.Entry::getKey).toList());
    }

    private <T> T wrap(String db, Function<EntityManager, T> function) {
        return (T)this.jpaApi.withTransaction(db, function);
    }

    private <T extends Collection> T wrapList(String db, Function<EntityManager, T> function) {
        return (T)((Collection)this.jpaApi.withTransaction(db, function));
    }

    protected String findShard(long primaryId) {
        return String.valueOf(primaryId / 1000000000000L + 1L);
    }

    protected <T> List<T> supplySync(Function<EntityManager, Collection<T>> function) {
        ArrayList futureList = Lists.newArrayList();
        for (String qualifier : this.DBNames) {
            futureList.add(CompletableFuture.supplyAsync(() -> this.wrapList(qualifier, function), (Executor)this.executionContextExecutor));
        }
        return (List)StreamEx.of((Collection)futureList).map(CompletableFuture::join).flatMap(Collection::stream).collect(Collectors.toList());
    }

    protected <T> CompletableFuture<List<T>> supplyAsync(Function<EntityManager, Collection<T>> function) {
        CompletionStage<List<T>> future = CompletableFuture.completedFuture(Lists.newArrayList());
        for (String qualifier : this.DBNames) {
            future = future.thenCombine(CompletableFuture.supplyAsync(() -> this.wrapList(qualifier, function)), (a, b) -> {
                a.addAll(b);
                return a;
            });
        }
        return future;
    }

    protected <T> CompletableFuture<T> supplyAsync(Function<EntityManager, T> function, String qualifier) {
        return CompletableFuture.supplyAsync(() -> this.wrap(qualifier, function), (Executor)this.executionContextExecutor);
    }

    protected <T> CompletableFuture<T> supplyAsync(Function<EntityManager, T> function, DBQualifier qualifier) {
        return CompletableFuture.supplyAsync(() -> this.wrap(this.getDBName(qualifier), function), (Executor)this.executionContextExecutor);
    }

    private String getDBName(DBQualifier qualifier) {
        switch (qualifier) {
            case LAST: {
                return this.last;
            }
            case FIRST: {
                return this.first;
            }
        }
        throw new ServiceException("Unknown DBQualifier " + (Object)((Object)qualifier));
    }

    protected static enum DBQualifier {
        LAST,
        FIRST;

    }
}

