/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.dbtool.redislisteners;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.lettuce.core.pubsub.RedisPubSubAdapter;
import ru.quadcom.datapack.domains.identity.Session;
import ru.quadcom.dbtool.IRedisChannel;
import ru.quadcom.dbtool.ISessionInMemoryCache;
import ru.quadcom.dbtool.redismessages.SessionMessage;

public class SessionListener
extends RedisPubSubAdapter<String, String> {
    private ISessionInMemoryCache sessionInMemoryCache;
    private IRedisChannel redisChannel;
    private final Gson gson = new GsonBuilder().create();

    public SessionListener(ISessionInMemoryCache sessionInMemoryCache, IRedisChannel redisChannel) {
        this.sessionInMemoryCache = sessionInMemoryCache;
        this.redisChannel = redisChannel;
    }

    public void message(String channel, String message) {
        if (this.redisChannel.getChannelName().equals(channel)) {
            SessionMessage sessionMessage = (SessionMessage)this.gson.fromJson(message, SessionMessage.class);
            Session oldSession = sessionMessage.getOldSession();
            Session newSession = sessionMessage.getNewSession();
            switch (sessionMessage.getType()) {
                case UPDATE: {
                    this.sessionInMemoryCache.invalidate(oldSession.getSessionId());
                    this.sessionInMemoryCache.put(newSession);
                    break;
                }
                case CREATE: {
                    this.sessionInMemoryCache.put(newSession);
                    break;
                }
                case EXPIRE: {
                    this.sessionInMemoryCache.invalidate(oldSession.getSessionId());
                }
            }
        }
    }
}

