/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.social.lib.vk.requests.friends;

import akka.dispatch.Futures;
import akka.dispatch.Mapper;
import com.google.inject.Inject;
import java.util.List;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.quadcom.social.lib.interfaces.IClient;
import ru.quadcom.social.lib.interfaces.IFriends;
import ru.quadcom.social.lib.vk.VKApiVersion;
import ru.quadcom.social.lib.vk.requests.friends.FriendsGetRequestVK;
import ru.quadcom.social.lib.vk.responses.friends.FriendsGetResponseVK;
import ru.quadcom.social.lib.vk.responses.objects.UserVK;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FriendsHelperVK
implements IFriends {
    private static final Logger logger = LoggerFactory.getLogger(FriendsHelperVK.class);
    private final ExecutionContext executionContext;
    private final IClient vkClient;

    @Inject
    public FriendsHelperVK(IClient vkClient) {
        this.vkClient = vkClient;
        this.executionContext = vkClient.getExecutionContext();
    }

    @Override
    public Future<List<UserVK>> getAllFriends(String accessToken) {
        return this.getAllFriends(accessToken, VKApiVersion.DEFAULT);
    }

    @Override
    public Future<List<UserVK>> getAllFriends(String accessToken, VKApiVersion apiVersion) {
        FriendsGetRequestVK requestVK = FriendsGetRequestVK.request(accessToken);
        requestVK = requestVK.withApiVersion(apiVersion);
        return this.friendsGet(requestVK, apiVersion);
    }

    @Override
    public Future<List<UserVK>> getFriends(String accessToken, Integer count, Integer offset) {
        return this.getFriends(accessToken, count, offset, VKApiVersion.DEFAULT);
    }

    @Override
    public Future<List<UserVK>> getFriends(String accessToken, Integer count, Integer offset, VKApiVersion apiVersion) {
        FriendsGetRequestVK requestVK = FriendsGetRequestVK.request(accessToken);
        requestVK = requestVK.withApiVersion(apiVersion);
        requestVK = requestVK.withCount(count);
        requestVK = requestVK.withOffset(offset);
        return this.friendsGet(requestVK, apiVersion);
    }

    private Future<List<UserVK>> friendsGet(FriendsGetRequestVK friendsGetRequestVK, VKApiVersion apiVersion) {
        Future<FriendsGetResponseVK> friendsGetResponseVKFuture = this.vkClient.makeRequestAndMapResponse(friendsGetRequestVK, apiVersion, FriendsGetResponseVK.class);
        return friendsGetResponseVKFuture.flatMap((Function1)new Mapper<FriendsGetResponseVK, Future<List<UserVK>>>(){

            public Future<List<UserVK>> apply(final FriendsGetResponseVK response) {
                return Futures.future((Callable)new Callable<List<UserVK>>(){

                    @Override
                    public List<UserVK> call() throws Exception {
                        return response.users();
                    }
                }, (ExecutionContext)FriendsHelperVK.this.executionContext);
            }
        }, this.executionContext);
    }
}

