/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.social.lib.vk.requests.auth;

import akka.dispatch.Futures;
import akka.dispatch.Mapper;
import com.google.inject.Inject;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.quadcom.social.lib.interfaces.IAuth;
import ru.quadcom.social.lib.interfaces.IClient;
import ru.quadcom.social.lib.vk.VKApiVersion;
import ru.quadcom.social.lib.vk.VKPermissions;
import ru.quadcom.social.lib.vk.requests.auth.ServerAppAuthGetAccessTokenRequestVK;
import ru.quadcom.social.lib.vk.requests.auth.ServerAuthGetAccessTokenRequestVK;
import ru.quadcom.social.lib.vk.requests.auth.ServerAuthRequestUrlRedirectBuilderVK;
import ru.quadcom.social.lib.vk.responses.auth.ServerAppAuthGetAccessTokenResponseVK;
import ru.quadcom.social.lib.vk.responses.auth.ServerAuthGetAccessTokenResponseVK;
import ru.quadcom.social.lib.vk.responses.objects.AccessTokenVK;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthHelperVK
implements IAuth {
    private static final Logger logger = LoggerFactory.getLogger(AuthHelperVK.class);
    private final ExecutionContext executionContext;
    private final IClient vkClient;

    @Inject
    public AuthHelperVK(IClient vkClient) {
        this.vkClient = vkClient;
        this.executionContext = vkClient.getExecutionContext();
    }

    @Override
    public String getUrlForRedirect(String clientId, String redirectUri, VKPermissions ... permissions) {
        ServerAuthRequestUrlRedirectBuilderVK serverAuthRequestUrlRedirectBuilderVK = ServerAuthRequestUrlRedirectBuilderVK.request(clientId, redirectUri, permissions);
        return serverAuthRequestUrlRedirectBuilderVK.redirectToUrl();
    }

    @Override
    public String getUrlForRedirect(String clientId, String redirectUri, VKApiVersion apiVersion, VKPermissions ... permissions) {
        ServerAuthRequestUrlRedirectBuilderVK serverAuthRequestUrlRedirectBuilderVK = ServerAuthRequestUrlRedirectBuilderVK.request(clientId, redirectUri, permissions);
        return serverAuthRequestUrlRedirectBuilderVK.redirectToUrl();
    }

    @Override
    public Future<AccessTokenVK> getAccessToken(String clientId, String redirectUri, String code, String applicationSecret) {
        ServerAuthGetAccessTokenRequestVK serverAuthGetAccessTokenRequestVK = ServerAuthGetAccessTokenRequestVK.request(clientId, redirectUri, code, applicationSecret);
        return this.getAccessToken(serverAuthGetAccessTokenRequestVK, VKApiVersion.DEFAULT);
    }

    @Override
    public Future<AccessTokenVK> getAccessToken(String clientId, String redirectUri, String code, String applicationSecret, VKApiVersion apiVersion) {
        ServerAuthGetAccessTokenRequestVK serverAuthGetAccessTokenRequestVK = ServerAuthGetAccessTokenRequestVK.request(clientId, redirectUri, code, applicationSecret);
        serverAuthGetAccessTokenRequestVK = serverAuthGetAccessTokenRequestVK.withApiVersion(apiVersion);
        return this.getAccessToken(serverAuthGetAccessTokenRequestVK, apiVersion);
    }

    @Override
    public Future<AccessTokenVK> getAppAccessToken(String clientId, String applicationSecret) {
        ServerAppAuthGetAccessTokenRequestVK requestVK = ServerAppAuthGetAccessTokenRequestVK.request(clientId, applicationSecret);
        return this.getAppAccessToken(requestVK, VKApiVersion.DEFAULT);
    }

    @Override
    public Future<AccessTokenVK> getAppAccessToken(String clientId, String applicationSecret, VKApiVersion apiVersion) {
        ServerAppAuthGetAccessTokenRequestVK requestVK = ServerAppAuthGetAccessTokenRequestVK.request(clientId, applicationSecret);
        requestVK = requestVK.withApiVersion(apiVersion);
        return this.getAppAccessToken(requestVK, VKApiVersion.DEFAULT);
    }

    private Future<AccessTokenVK> getAccessToken(ServerAuthGetAccessTokenRequestVK getAccessTokenRequest, VKApiVersion apiVersion) {
        Future<ServerAuthGetAccessTokenResponseVK> serverAuthGetAccessTokenResponseVKFuture = this.vkClient.makeRequestAndMapResponse(getAccessTokenRequest, apiVersion, ServerAuthGetAccessTokenResponseVK.class);
        return serverAuthGetAccessTokenResponseVKFuture.flatMap((Function1)new Mapper<ServerAuthGetAccessTokenResponseVK, Future<AccessTokenVK>>(){

            public Future<AccessTokenVK> apply(final ServerAuthGetAccessTokenResponseVK responseVK) {
                return Futures.future((Callable)new Callable<AccessTokenVK>(){

                    @Override
                    public AccessTokenVK call() throws Exception {
                        return new AccessTokenVK(responseVK.getAccess_token(), responseVK.getExpires_in(), responseVK.getUser_id());
                    }
                }, (ExecutionContext)AuthHelperVK.this.executionContext);
            }
        }, this.executionContext);
    }

    private Future<AccessTokenVK> getAppAccessToken(ServerAppAuthGetAccessTokenRequestVK getAccessTokenRequest, VKApiVersion apiVersion) {
        Future<ServerAppAuthGetAccessTokenResponseVK> serverAppAuthGetAccessTokenResponseVKFuture = this.vkClient.makeRequestAndMapResponse(getAccessTokenRequest, apiVersion, ServerAppAuthGetAccessTokenResponseVK.class);
        return serverAppAuthGetAccessTokenResponseVKFuture.flatMap((Function1)new Mapper<ServerAppAuthGetAccessTokenResponseVK, Future<AccessTokenVK>>(){

            public Future<AccessTokenVK> apply(final ServerAppAuthGetAccessTokenResponseVK responseVK) {
                return Futures.future((Callable)new Callable<AccessTokenVK>(){

                    @Override
                    public AccessTokenVK call() throws Exception {
                        return new AccessTokenVK(responseVK.getAccess_token(), null, null);
                    }
                }, (ExecutionContext)AuthHelperVK.this.executionContext);
            }
        }, this.executionContext);
    }
}

