/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.social.lib.ok.requests.notifications;

import com.google.inject.Inject;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.quadcom.social.lib.ok.interfaces.IOkAppClient;
import ru.quadcom.social.lib.ok.interfaces.IOkNotifications;
import ru.quadcom.social.lib.ok.requests.notifications.NotificationsSendMassRequestOk;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationsHelperOk
implements IOkNotifications {
    private static final Logger logger = LoggerFactory.getLogger(NotificationsHelperOk.class);
    private final ExecutionContext executionContext;
    private final IOkAppClient appClient;

    @Inject
    public NotificationsHelperOk(IOkAppClient appClient) {
        this.executionContext = appClient.getExecutionContext();
        this.appClient = appClient;
    }

    @Override
    public Future<String> sendMass(String applicationKey, String applicationSecret, String text, DateTime expires) {
        logger.debug("sendMass : application key : [{}], application secret : [{}], text : [{}], expires : [{}]", new Object[]{applicationKey, applicationSecret, text, expires});
        NotificationsSendMassRequestOk requestOk = NotificationsSendMassRequestOk.request(applicationKey, applicationSecret, text, expires);
        return this.appClient.makeRequestAndMapResponse(requestOk, String.class);
    }
}

