/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.social.lib.my.client;

import akka.dispatch.Futures;
import akka.dispatch.Mapper;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.libs.ws.WSResponse;
import ru.quadcom.social.lib.my.exceptions.ExceptionMapperMy;
import ru.quadcom.social.lib.my.interfaces.IMyAppClient;
import ru.quadcom.social.lib.my.requests.AbstractApplicationMyRequest;
import ru.quadcom.social.lib.my.responses.objects.ErrorMy;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyAppClient
implements IMyAppClient {
    private static final Logger logger = LoggerFactory.getLogger(MyAppClient.class);
    private static final Gson gson = new Gson();
    private final ExecutionContext executionContext;

    public MyAppClient(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    @Override
    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    @Override
    public <T> Future<T> makeRequestAndMapResponse(AbstractApplicationMyRequest request, final Class<T> clazz) {
        Future<String> responseFuture = this.makeRequest(request);
        Future responseMyFuture = responseFuture.flatMap((Function1)new Mapper<String, Future<T>>(){

            public Future<T> apply(final String responseBody) {
                return Futures.future((Callable)new Callable<T>(){

                    @Override
                    public T call() throws Exception {
                        try {
                            Object responseMy = gson.fromJson(responseBody, clazz);
                            logger.info("After mapping : " + responseMy);
                            return responseMy;
                        }
                        catch (JsonSyntaxException e) {
                            logger.info("Catch exception : return as String");
                            return responseBody;
                        }
                    }
                }, (ExecutionContext)MyAppClient.this.executionContext);
            }
        }, this.executionContext);
        return responseMyFuture;
    }

    private Future<String> makeRequest(AbstractApplicationMyRequest abstractRequestMy) {
        logger.info("makeRequest()");
        Future<Map<String, Object>> responseStringFuture = this.futureResponse(abstractRequestMy, this.executionContext);
        return responseStringFuture.flatMap((Function1)new Mapper<Map<String, Object>, Future<String>>(){

            public Future<String> apply(final Map<String, Object> resultMap) {
                return Futures.future((Callable)new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        int statusCode = (Integer)resultMap.get("STATUS");
                        String responseBody = (String)resultMap.get("RESULT");
                        logger.info("makeRequest() : receive response : " + responseBody + " statusCode : " + statusCode);
                        if (responseBody.contains("\"error\"")) {
                            ExceptionMapperMy.throwMyException(responseBody);
                        }
                        return responseBody;
                    }
                }, (ExecutionContext)MyAppClient.this.executionContext);
            }
        }, this.executionContext);
    }

    private Future<Map<String, Object>> futureResponse(final AbstractApplicationMyRequest abstractRequestMy, final ExecutionContext executionContext) {
        Future firstTryFuture = abstractRequestMy.requestHolder().get().wrapped().flatMap((Function1)new Mapper<WSResponse, Future<Map<String, Object>>>(){

            public Future<Map<String, Object>> apply(final WSResponse firstResponse) {
                return Futures.future((Callable)new Callable<Map<String, Object>>(){

                    @Override
                    public Map<String, Object> call() throws Exception {
                        ErrorMy errorMy;
                        HashMap<String, Object> result = new HashMap<String, Object>();
                        int statusCode = firstResponse.getStatus();
                        result.put("STATUS", statusCode);
                        String responseBody = firstResponse.getBody();
                        if (responseBody.contains("\"error\"") && ((errorMy = (ErrorMy)gson.fromJson(responseBody, ErrorMy.class)).errorCode() == 1 || errorMy.errorCode() == 3)) {
                            logger.warn("futureResponse() : first try " + abstractRequestMy.url() + " : Service temporarily unavailable or Unknown error : retry after one sec");
                            result.put("RETRY", Boolean.TRUE);
                            result.put("TIME", System.currentTimeMillis());
                            return result;
                        }
                        logger.warn("futureResponse() : first try : don't retry return result");
                        result.put("RETRY", Boolean.FALSE);
                        result.put("RESULT", responseBody);
                        return result;
                    }
                }, (ExecutionContext)executionContext);
            }
        }, executionContext);
        Future secondTryFuture = firstTryFuture.flatMap((Function1)new Mapper<Map<String, Object>, Future<Map<String, Object>>>(){

            public Future<Map<String, Object>> apply(final Map<String, Object> firstTryResultMap) {
                if (((Boolean)firstTryResultMap.get("RETRY")).booleanValue()) {
                    Long time = (Long)firstTryResultMap.get("TIME");
                    long currentTime = System.currentTimeMillis();
                    long howManyToOneSecWait = 1000L - (currentTime - time);
                    if (howManyToOneSecWait > 0L) {
                        try {
                            logger.warn("futureResponse() : second try : start waiting for " + howManyToOneSecWait + " sec in " + System.currentTimeMillis());
                            Thread.currentThread();
                            Thread.sleep(howManyToOneSecWait);
                            logger.warn("futureResponse() : second try : finish waiting in " + System.currentTimeMillis());
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    return abstractRequestMy.requestHolder().get().wrapped().flatMap((Function1)new Mapper<WSResponse, Future<Map<String, Object>>>(){

                        public Future<Map<String, Object>> apply(final WSResponse secondResponse) {
                            return Futures.future((Callable)new Callable<Map<String, Object>>(){

                                @Override
                                public Map<String, Object> call() throws Exception {
                                    ErrorMy errorMy;
                                    HashMap<String, Object> result = new HashMap<String, Object>();
                                    int statusCode = secondResponse.getStatus();
                                    result.put("STATUS", statusCode);
                                    String responseBody = secondResponse.getBody();
                                    if (responseBody.contains("\"error\"") && ((errorMy = (ErrorMy)gson.fromJson(responseBody, ErrorMy.class)).errorCode() == 1 || errorMy.errorCode() == 3)) {
                                        logger.warn("futureResponse() : second try " + abstractRequestMy.url() + " : Service temporarily unavailable or Unknown error : retry after one sec");
                                        result.put("RETRY", Boolean.TRUE);
                                        result.put("TIME", System.currentTimeMillis());
                                        return result;
                                    }
                                    logger.warn("futureResponse() : second try : don't retry return result");
                                    result.put("RETRY", Boolean.FALSE);
                                    result.put("RESULT", responseBody);
                                    return result;
                                }
                            }, (ExecutionContext)executionContext);
                        }
                    }, executionContext);
                }
                return Futures.future((Callable)new Callable<Map<String, Object>>(){

                    @Override
                    public Map<String, Object> call() throws Exception {
                        return firstTryResultMap;
                    }
                }, (ExecutionContext)executionContext);
            }
        }, executionContext);
        Future thirdTryFuture = secondTryFuture.flatMap((Function1)new Mapper<Map<String, Object>, Future<Map<String, Object>>>(){

            public Future<Map<String, Object>> apply(final Map<String, Object> secondTryResultMap) {
                if (((Boolean)secondTryResultMap.get("RETRY")).booleanValue()) {
                    Long time = (Long)secondTryResultMap.get("TIME");
                    long currentTime = System.currentTimeMillis();
                    long howManyToOneSecWait = 2000L - (currentTime - time);
                    if (howManyToOneSecWait > 0L) {
                        try {
                            logger.warn("futureResponse() : third try : start waiting for " + howManyToOneSecWait + " sec in " + System.currentTimeMillis());
                            Thread.currentThread();
                            Thread.sleep(howManyToOneSecWait);
                            logger.warn("futureResponse() : third try : finish waiting in " + System.currentTimeMillis());
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    return abstractRequestMy.requestHolder().get().wrapped().flatMap((Function1)new Mapper<WSResponse, Future<Map<String, Object>>>(){

                        public Future<Map<String, Object>> apply(final WSResponse thirdResponse) {
                            return Futures.future((Callable)new Callable<Map<String, Object>>(){

                                @Override
                                public Map<String, Object> call() throws Exception {
                                    HashMap<String, Object> result = new HashMap<String, Object>();
                                    String responseBody = thirdResponse.getBody();
                                    result.put("STATUS", thirdResponse.getStatus());
                                    result.put("RETRY", Boolean.FALSE);
                                    result.put("RESULT", responseBody);
                                    logger.warn("futureResponse() : third try : return any result");
                                    return result;
                                }
                            }, (ExecutionContext)executionContext);
                        }
                    }, executionContext);
                }
                return Futures.future((Callable)new Callable<Map<String, Object>>(){

                    @Override
                    public Map<String, Object> call() throws Exception {
                        return secondTryResultMap;
                    }
                }, (ExecutionContext)executionContext);
            }
        }, executionContext);
        return thirdTryFuture;
    }
}

