/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.social.lib.vk.requests.users;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import play.libs.WS;
import ru.quadcom.social.lib.vk.VK;
import ru.quadcom.social.lib.vk.VKApiVersion;
import ru.quadcom.social.lib.vk.requests.AbstractRequest;
import ru.quadcom.social.lib.vk.responses.objects.UserVK;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsersGetRequestVK
extends AbstractRequest {
    protected final String url = VK.GRAPH_HOST.url().concat("/users.get");
    protected final ImmutableSet<Long> userIds;
    protected final ImmutableSet<Fields> fields;
    protected final NameCase nameCase;

    public static UsersGetRequestVK request(String accessToken) {
        Preconditions.checkArgument((accessToken != null && !accessToken.isEmpty() ? 1 : 0) != 0, (Object)"accessToken is null or empty");
        return new UsersGetRequestVK(VKApiVersion.DEFAULT, accessToken, null, null, null);
    }

    private UsersGetRequestVK(VKApiVersion apiVersion, String accessToken, Set<Long> userIds, Set<Fields> fields, NameCase nameCase) {
        super(apiVersion, accessToken);
        this.userIds = userIds != null ? ImmutableSet.copyOf(userIds) : null;
        this.fields = fields != null ? ImmutableSet.copyOf(fields) : null;
        this.nameCase = nameCase;
    }

    public UsersGetRequestVK withApiVersion(VKApiVersion apiVersion) {
        return new UsersGetRequestVK(apiVersion, this.accessToken, (Set<Long>)this.userIds, (Set<Fields>)this.fields, this.nameCase);
    }

    public UsersGetRequestVK withUserIds(Set<Long> userIds) {
        Preconditions.checkArgument((userIds != null && !userIds.isEmpty() ? 1 : 0) != 0, (Object)"userIds is null or empty");
        Preconditions.checkArgument((userIds.size() < 1000 ? 1 : 0) != 0, (Object)"userIds.size should be less than 1000");
        for (Long eachUserId : userIds) {
            Preconditions.checkArgument((eachUserId > 0L ? 1 : 0) != 0, (Object)"one of userIds < 0");
        }
        return new UsersGetRequestVK(this.apiVersion, this.accessToken, userIds, (Set<Fields>)this.fields, this.nameCase);
    }

    public UsersGetRequestVK withFields(Set<Fields> fields) {
        Preconditions.checkArgument((fields != null && !fields.isEmpty() ? 1 : 0) != 0, (Object)"fields is null or empty");
        return new UsersGetRequestVK(this.apiVersion, this.accessToken, (Set<Long>)this.userIds, fields, this.nameCase);
    }

    public UsersGetRequestVK withNameCase(NameCase nameCase) {
        Preconditions.checkArgument((nameCase != null ? 1 : 0) != 0, (Object)"nameCase is null");
        return new UsersGetRequestVK(this.apiVersion, this.accessToken, (Set<Long>)this.userIds, (Set<Fields>)this.fields, nameCase);
    }

    @Override
    public WS.WSRequestHolder requestHolder() {
        WS.WSRequestHolder requestHolder = this.baseRequest(this.url);
        if (this.userIds != null && !this.userIds.isEmpty()) {
            requestHolder = requestHolder.setQueryParameter("user_ids", this.collectionAsStringWithComaSeparator((Collection)this.userIds));
        }
        if (this.fields != null && !this.fields.isEmpty()) {
            requestHolder = requestHolder.setQueryParameter("fields", this.collectionAsStringWithComaSeparator((Collection)this.fields));
        }
        if (this.nameCase != null) {
            requestHolder = requestHolder.setQueryParameter("name_case", this.nameCase.name());
        }
        return requestHolder;
    }

    @Override
    public String asArgumentToExecuteMethod() {
        StringBuilder stringBuilder = new StringBuilder("API.users.get(");
        boolean useIds = false;
        boolean useFields = false;
        boolean useNameCase = false;
        if (this.userIds != null && !this.userIds.isEmpty()) {
            stringBuilder.append("{\"user_ids\":\"");
            stringBuilder.append(this.collectionAsStringWithComaSeparator((Collection)this.userIds));
            stringBuilder.append("\"");
            useIds = true;
        }
        if (this.fields != null && !this.fields.isEmpty()) {
            if (useIds) {
                stringBuilder.append(",");
            } else {
                stringBuilder.append("{");
            }
            stringBuilder.append("\"fields\":\"");
            stringBuilder.append(this.collectionAsStringWithComaSeparator((Collection)this.fields));
            stringBuilder.append("\"");
            useFields = true;
        }
        if (this.nameCase != null) {
            if (useIds || useFields) {
                stringBuilder.append(",");
            } else {
                stringBuilder.append("{");
            }
            stringBuilder.append("\"name_case\":\"");
            stringBuilder.append(this.nameCase.name());
            stringBuilder.append("\"");
            useNameCase = true;
        }
        if (useIds || useFields || useNameCase) {
            stringBuilder.append("}");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public List transformExecuteResponseIntoResponseList(String partOfResponse) {
        Gson gson = new Gson();
        Type collectionType = new TypeToken<List<UserVK>>(){}.getType();
        List users = (List)gson.fromJson(partOfResponse, collectionType);
        return users;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NameCase {
        nom,
        gen,
        dat,
        acc,
        ins,
        abl;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Fields {
        nickname,
        screen_name,
        sex,
        bdate,
        city,
        country,
        timezone,
        photo_50,
        photo_100,
        photo_200_orig,
        has_mobile,
        contacts,
        connections,
        education,
        online,
        counters,
        relation,
        last_seen,
        status,
        can_write_private_message,
        can_see_all_posts,
        can_see_audio,
        can_post,
        universities,
        schools,
        verified;


        public static Set<Fields> all() {
            return new HashSet<Fields>(Arrays.asList(Fields.values()));
        }
    }
}

