/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.social.lib.vk.requests.secure;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import play.libs.WS;
import ru.quadcom.social.lib.vk.VK;
import ru.quadcom.social.lib.vk.VKApiVersion;
import ru.quadcom.social.lib.vk.requests.AbstractRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendNotificationRequestVK
extends AbstractRequest {
    protected final String url;
    protected final ImmutableSet<Long> userIds;
    protected final String message;
    protected final String applicationSecret;

    protected SendNotificationRequestVK(VKApiVersion apiVersion, String accessToken, Set<Long> userIds, String message, String applicationSecret) {
        super(apiVersion, accessToken);
        this.applicationSecret = applicationSecret;
        this.url = VK.GRAPH_HOST.url().concat("/secure.sendNotification");
        this.userIds = userIds != null ? ImmutableSet.copyOf(userIds) : null;
        this.message = message;
    }

    @Override
    public WS.WSRequestHolder requestHolder() {
        WS.WSRequestHolder requestHolder = this.baseRequest(this.url);
        if (this.userIds != null && !this.userIds.isEmpty()) {
            requestHolder = requestHolder.setQueryParameter("user_ids", this.collectionAsStringWithComaSeparator((Collection)this.userIds));
        }
        if (this.message != null) {
            requestHolder = requestHolder.setQueryParameter("message", this.message);
        }
        requestHolder = requestHolder.setQueryParameter("client_secret", this.applicationSecret);
        return requestHolder;
    }

    @Override
    public String asArgumentToExecuteMethod() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public List transformExecuteResponseIntoResponseList(String s) {
        throw new UnsupportedOperationException("Not supported");
    }
}

