/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.social.lib.vk.requests.secure;

import akka.dispatch.Futures;
import akka.dispatch.Mapper;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.Set;
import java.util.concurrent.Callable;
import ru.quadcom.social.lib.interfaces.IClient;
import ru.quadcom.social.lib.interfaces.ISecureAPI;
import ru.quadcom.social.lib.vk.VKApiVersion;
import ru.quadcom.social.lib.vk.requests.secure.SendNotificationRequestVK;
import ru.quadcom.social.lib.vk.responses.secure.SecureSendNotificationResponseVK;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecureAPIHelper
implements ISecureAPI {
    private final IClient client;

    @Inject
    public SecureAPIHelper(IClient client) {
        this.client = client;
    }

    @Override
    public Future<ImmutableList<Long>> sendNotification(Set<Long> userIds, String message, String accessToken, String clientSecret) {
        return this.sendNotification(VKApiVersion.DEFAULT, userIds, message, accessToken, clientSecret);
    }

    @Override
    public Future<ImmutableList<Long>> sendNotification(VKApiVersion apiVersion, Set<Long> userIds, String message, String accessToken, String clientSecret) {
        return this.client.makeRequestAndMapResponse(new SendNotificationRequestVK(apiVersion, accessToken, userIds, message, clientSecret), VKApiVersion.DEFAULT, SecureSendNotificationResponseVK.class).flatMap((Function1)new Mapper<SecureSendNotificationResponseVK, Future<ImmutableList<Long>>>(){

            public Future<ImmutableList<Long>> apply(final SecureSendNotificationResponseVK responseVK) {
                return Futures.future((Callable)new Callable<ImmutableList<Long>>(){

                    @Override
                    public ImmutableList<Long> call() throws Exception {
                        String[] strings = responseVK.getResponse().split(",");
                        ImmutableList.Builder resultBuilder = ImmutableList.builder();
                        for (String accId : strings) {
                            if (accId.isEmpty()) continue;
                            resultBuilder.add((Object)Long.parseLong(accId));
                        }
                        return resultBuilder.build();
                    }
                }, (ExecutionContext)SecureAPIHelper.this.client.getExecutionContext());
            }
        }, this.client.getExecutionContext());
    }
}

