/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.social.lib.vk.requests.friends;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import play.libs.WS;
import ru.quadcom.social.lib.vk.VK;
import ru.quadcom.social.lib.vk.VKApiVersion;
import ru.quadcom.social.lib.vk.requests.AbstractRequest;
import ru.quadcom.social.lib.vk.responses.friends.FriendsGetInnerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FriendsGetRequestVK
extends AbstractRequest {
    protected final String url = VK.GRAPH_HOST.url().concat("/friends.get");
    protected final Long userId;
    protected final ImmutableSet<Fields> fields;
    protected final NameCase nameCase;
    protected final Integer count;
    protected final Integer offset;

    public static FriendsGetRequestVK request(String accessToken) {
        Preconditions.checkArgument((accessToken != null && !accessToken.isEmpty() ? 1 : 0) != 0, (Object)"accessToken is null or empty");
        return new FriendsGetRequestVK(VKApiVersion.DEFAULT, accessToken, null, null, null, null, null);
    }

    private FriendsGetRequestVK(VKApiVersion apiVersion, String accessToken, Long userId, Set<Fields> fields, NameCase nameCase, Integer count, Integer offset) {
        super(apiVersion, accessToken);
        this.userId = userId;
        this.fields = fields != null ? ImmutableSet.copyOf(fields) : ImmutableSet.of((Object)((Object)Fields.sex));
        this.nameCase = nameCase;
        this.count = count;
        this.offset = offset;
    }

    public FriendsGetRequestVK withApiVersion(VKApiVersion apiVersion) {
        return new FriendsGetRequestVK(apiVersion, this.accessToken, this.userId, (Set<Fields>)this.fields, this.nameCase, this.count, this.offset);
    }

    public FriendsGetRequestVK withUserId(Long userId) {
        Preconditions.checkArgument((userId != null ? 1 : 0) != 0, (Object)"userId is null or empty");
        return new FriendsGetRequestVK(this.apiVersion, this.accessToken, userId, (Set<Fields>)this.fields, this.nameCase, this.count, this.offset);
    }

    public FriendsGetRequestVK withFields(Set<Fields> fields) {
        Preconditions.checkArgument((fields != null && !fields.isEmpty() ? 1 : 0) != 0, (Object)"fields is null or empty");
        return new FriendsGetRequestVK(this.apiVersion, this.accessToken, this.userId, fields, this.nameCase, this.count, this.offset);
    }

    public FriendsGetRequestVK withNameCase(NameCase nameCase) {
        Preconditions.checkArgument((nameCase != null ? 1 : 0) != 0, (Object)"nameCase is null");
        return new FriendsGetRequestVK(this.apiVersion, this.accessToken, this.userId, (Set<Fields>)this.fields, nameCase, this.count, this.offset);
    }

    public FriendsGetRequestVK withCount(Integer count) {
        Preconditions.checkArgument((count != null ? 1 : 0) != 0, (Object)"count is null");
        return new FriendsGetRequestVK(this.apiVersion, this.accessToken, this.userId, (Set<Fields>)this.fields, this.nameCase, count, this.offset);
    }

    public FriendsGetRequestVK withOffset(Integer offset) {
        Preconditions.checkArgument((offset != null ? 1 : 0) != 0, (Object)"offset is null");
        return new FriendsGetRequestVK(this.apiVersion, this.accessToken, this.userId, (Set<Fields>)this.fields, this.nameCase, this.count, offset);
    }

    @Override
    public WS.WSRequestHolder requestHolder() {
        WS.WSRequestHolder requestHolder = this.baseRequest(this.url);
        if (this.userId != null) {
            requestHolder = requestHolder.setQueryParameter("user_id", this.userId.toString());
        }
        if (this.fields != null && !this.fields.isEmpty()) {
            requestHolder = requestHolder.setQueryParameter("fields", this.collectionAsStringWithComaSeparator((Collection)this.fields));
        }
        if (this.nameCase != null) {
            requestHolder = requestHolder.setQueryParameter("name_case", this.nameCase.name());
        }
        if (this.count != null) {
            requestHolder = requestHolder.setQueryParameter("count", this.count.toString());
        }
        if (this.offset != null) {
            requestHolder = requestHolder.setQueryParameter("offset", this.offset.toString());
        }
        return requestHolder;
    }

    @Override
    public String asArgumentToExecuteMethod() {
        StringBuilder stringBuilder = new StringBuilder("API.friends.get(");
        boolean useId = false;
        boolean useFields = false;
        boolean useNameCase = false;
        boolean useCount = false;
        boolean useOffset = false;
        if (this.userId != null) {
            stringBuilder.append("{\"user_id\":\"");
            stringBuilder.append(this.userId);
            stringBuilder.append("\"");
            useId = true;
        }
        if (this.fields != null && !this.fields.isEmpty()) {
            if (useId) {
                stringBuilder.append(",");
            } else {
                stringBuilder.append("{");
            }
            stringBuilder.append("\"fields\":\"");
            stringBuilder.append(this.collectionAsStringWithComaSeparator((Collection)this.fields));
            stringBuilder.append("\"");
            useFields = true;
        }
        if (this.nameCase != null) {
            if (useId || useFields) {
                stringBuilder.append(",");
            } else {
                stringBuilder.append("{");
            }
            stringBuilder.append("\"name_case\":\"");
            stringBuilder.append(this.nameCase.name());
            stringBuilder.append("\"");
            useNameCase = true;
        }
        if (this.count != null) {
            if (useId || useFields || useNameCase) {
                stringBuilder.append(",");
            } else {
                stringBuilder.append("{");
            }
            stringBuilder.append("\"count\":\"");
            stringBuilder.append(this.count.toString());
            stringBuilder.append("\"");
            useCount = true;
        }
        if (this.offset != null) {
            if (useId || useFields || useNameCase || useCount) {
                stringBuilder.append(",");
            } else {
                stringBuilder.append("{");
            }
            stringBuilder.append("\"offset\":\"");
            stringBuilder.append(this.offset.toString());
            stringBuilder.append("\"");
            useOffset = true;
        }
        if (useId || useFields || useNameCase || useCount || useOffset) {
            stringBuilder.append("}");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public List transformExecuteResponseIntoResponseList(String partOfResponse) {
        Gson gson = new Gson();
        Type collectionType = new TypeToken<List<FriendsGetInnerResponse>>(){}.getType();
        StringBuilder stringBuilder = new StringBuilder("[");
        stringBuilder.append(partOfResponse);
        stringBuilder.append("]");
        List friendsGetInnerResponseList = (List)gson.fromJson(stringBuilder.toString(), collectionType);
        ArrayList<ArrayList> result = new ArrayList<ArrayList>();
        for (FriendsGetInnerResponse eachList : friendsGetInnerResponseList) {
            result.add(Lists.newArrayList(eachList.getItems()));
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NameCase {
        nom,
        gen,
        dat,
        acc,
        ins,
        abl;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Fields {
        nickname,
        domain,
        sex,
        bdate,
        city,
        country,
        timezone,
        photo_50,
        photo_100,
        photo_200_orig,
        has_mobile,
        contacts,
        education,
        online,
        relation,
        last_seen,
        status,
        can_write_private_message,
        can_see_all_posts,
        can_post,
        universities;


        public static Set<Fields> all() {
            return new HashSet<Fields>(Arrays.asList(Fields.values()));
        }
    }
}

