/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.social.lib.vk.requests.auth;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import ru.quadcom.social.lib.vk.VK;
import ru.quadcom.social.lib.vk.VKApiVersion;
import ru.quadcom.social.lib.vk.VKPermissions;
import ru.quadcom.social.lib.vk.VKResponseType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerAuthRequestUrlRedirectBuilderVK {
    protected final VKApiVersion apiVersion;
    protected final String url;
    protected final String clientId;
    protected final ImmutableSet<VKPermissions> scope;
    protected final String redirectUri;
    protected final VKResponseType responseType;

    public static ServerAuthRequestUrlRedirectBuilderVK request(String clientId, String redirectUri, VKPermissions ... permissions) {
        Preconditions.checkArgument((clientId != null && !clientId.isEmpty() ? 1 : 0) != 0, (Object)"clientId null or empty");
        Preconditions.checkArgument((redirectUri != null && !redirectUri.isEmpty() ? 1 : 0) != 0, (Object)"redirectUri null or empty");
        HashSet<VKPermissions> permissionsSet = new HashSet<VKPermissions>();
        if (permissions != null) {
            for (VKPermissions eachPermission : permissions) {
                permissionsSet.add(eachPermission);
            }
        }
        return new ServerAuthRequestUrlRedirectBuilderVK(clientId, permissionsSet, redirectUri, VKResponseType.code, VKApiVersion.DEFAULT);
    }

    private ServerAuthRequestUrlRedirectBuilderVK(String clientId, Set<VKPermissions> scope, String redirectUri, VKResponseType responseType, VKApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        this.url = VK.AUTH_URL.url();
        this.clientId = clientId;
        this.scope = ImmutableSet.copyOf(scope);
        this.redirectUri = redirectUri;
        this.responseType = responseType;
    }

    public ServerAuthRequestUrlRedirectBuilderVK withResponseType(VKResponseType responseType) {
        Preconditions.checkArgument((responseType != null ? 1 : 0) != 0, (Object)"responseType is null");
        return new ServerAuthRequestUrlRedirectBuilderVK(this.clientId, (Set<VKPermissions>)this.scope, this.redirectUri, responseType, this.apiVersion);
    }

    public ServerAuthRequestUrlRedirectBuilderVK withApiVersion(VKApiVersion apiVersion) {
        Preconditions.checkArgument((apiVersion != null ? 1 : 0) != 0, (Object)"apiVersion is null");
        return new ServerAuthRequestUrlRedirectBuilderVK(this.clientId, (Set<VKPermissions>)this.scope, this.redirectUri, this.responseType, apiVersion);
    }

    private String scopeAsString() {
        StringBuilder scopeBuilder = new StringBuilder();
        int index = 0;
        for (VKPermissions eachPermission : this.scope) {
            scopeBuilder.append(eachPermission.name());
            if (++index == this.scope.size()) continue;
            scopeBuilder.append(",");
        }
        return scopeBuilder.toString();
    }

    public String redirectToUrl() {
        StringBuilder stringBuilder = new StringBuilder(this.url);
        stringBuilder.append("?client_id=");
        stringBuilder.append(this.clientId);
        if (!this.scope.isEmpty()) {
            stringBuilder.append("&scope=");
            stringBuilder.append(this.scopeAsString());
        }
        stringBuilder.append("&redirect_uri=");
        stringBuilder.append(this.redirectUri);
        stringBuilder.append("&response_type=");
        stringBuilder.append(this.responseType.name());
        stringBuilder.append("&v=");
        stringBuilder.append(this.apiVersion.asString());
        return stringBuilder.toString();
    }
}

