/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.social.lib.vk.requests.auth;

import com.google.common.base.Preconditions;
import java.util.List;
import play.libs.WS;
import ru.quadcom.social.lib.vk.VK;
import ru.quadcom.social.lib.vk.VKApiVersion;
import ru.quadcom.social.lib.vk.requests.AbstractRequest;

public class ServerAuthGetAccessTokenRequestVK
extends AbstractRequest {
    protected final String url = VK.TOKEN_URL.url();
    protected final VKApiVersion apiVersion;
    protected final String clientId;
    protected final String redirectUri;
    protected final String code;
    protected final String applicationSecret;

    public static ServerAuthGetAccessTokenRequestVK request(String clientId, String redirectUri, String code, String applicationSecret) {
        Preconditions.checkArgument((clientId != null && !clientId.isEmpty() ? 1 : 0) != 0, (Object)"clientId null or empty");
        Preconditions.checkArgument((redirectUri != null && !redirectUri.isEmpty() ? 1 : 0) != 0, (Object)"redirectUri null or empty");
        Preconditions.checkArgument((code != null && !code.isEmpty() ? 1 : 0) != 0, (Object)"code null or empty");
        Preconditions.checkArgument((applicationSecret != null && !applicationSecret.isEmpty() ? 1 : 0) != 0, (Object)"applicationSecret null or empty");
        return new ServerAuthGetAccessTokenRequestVK(clientId, redirectUri, code, applicationSecret, VKApiVersion.DEFAULT);
    }

    private ServerAuthGetAccessTokenRequestVK(String clientId, String redirectUri, String code, String applicationSecret, VKApiVersion apiVersion) {
        super(null, null);
        this.apiVersion = apiVersion;
        this.clientId = clientId;
        this.redirectUri = redirectUri;
        this.code = code;
        this.applicationSecret = applicationSecret;
    }

    public ServerAuthGetAccessTokenRequestVK withApiVersion(VKApiVersion apiVersion) {
        Preconditions.checkArgument((apiVersion != null ? 1 : 0) != 0, (Object)"apiVersion is null");
        return new ServerAuthGetAccessTokenRequestVK(this.clientId, this.redirectUri, this.code, this.applicationSecret, apiVersion);
    }

    public WS.WSRequestHolder requestHolder() {
        WS.WSRequestHolder requestHolder = WS.url((String)this.url);
        requestHolder = requestHolder.setQueryParameter("client_id", this.clientId);
        requestHolder = requestHolder.setQueryParameter("client_secret", this.applicationSecret);
        requestHolder = requestHolder.setQueryParameter("code", this.code);
        requestHolder = requestHolder.setQueryParameter("redirect_uri", this.redirectUri);
        requestHolder = requestHolder.setQueryParameter("v", this.apiVersion.asString());
        return requestHolder;
    }

    public String asArgumentToExecuteMethod() {
        throw new UnsupportedOperationException("Not supported");
    }

    public List transformExecuteResponseIntoResponseList(String partOfResponse) {
        throw new UnsupportedOperationException("Not supported");
    }
}

