/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.dynamo.db.lib.transactions;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapper;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperConfig;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.DescribeTableRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeTableResult;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemResult;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.ResourceInUseException;
import com.amazonaws.services.dynamodbv2.model.ResourceNotFoundException;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.quadcom.dynamo.db.lib.manage.AppDynamoDBClient;
import ru.quadcom.dynamo.db.lib.transactions.TableHelper;
import ru.quadcom.dynamo.db.lib.transactions.ThreadLocalDynamoDBFacade;
import ru.quadcom.dynamo.db.lib.transactions.Transaction;
import ru.quadcom.dynamo.db.lib.transactions.TransactionItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionManager {
    private static final Logger log = LoggerFactory.getLogger(TransactionManager.class);
    private static final List<AttributeDefinition> TRANSACTIONS_TABLE_ATTRIBUTES;
    private static final List<KeySchemaElement> TRANSACTIONS_TABLE_KEY_SCHEMA;
    private static final List<AttributeDefinition> TRANSACTION_IMAGES_TABLE_ATTRIBUTES;
    private static final List<KeySchemaElement> TRANSACTION_IMAGES_TABLE_KEY_SCHEMA;
    private final AppDynamoDBClient client;
    private final String transactionTableName = "transactions";
    private final String itemImageTableName = "transactionImages";
    private final ConcurrentHashMap<String, List<KeySchemaElement>> tableSchemaCache = new ConcurrentHashMap();
    private final DynamoDBMapper clientMapper;
    private final ThreadLocalDynamoDBFacade facadeProxy;

    public TransactionManager(AppDynamoDBClient client) {
        this(client, DynamoDBMapperConfig.DEFAULT);
    }

    private TransactionManager(AppDynamoDBClient client, DynamoDBMapperConfig config) {
        if (client == null) {
            throw new IllegalArgumentException("client must not be null");
        }
        this.client = client;
        this.facadeProxy = new ThreadLocalDynamoDBFacade();
        this.clientMapper = new DynamoDBMapper((AmazonDynamoDB)this.facadeProxy, config);
    }

    protected List<KeySchemaElement> getTableSchema(String tableName) throws ResourceNotFoundException {
        List<Object> schema = this.tableSchemaCache.get(tableName);
        if (schema == null) {
            DescribeTableResult result = this.client.describeTable(new DescribeTableRequest().withTableName(tableName));
            schema = Collections.unmodifiableList(result.getTable().getKeySchema());
            this.tableSchemaCache.put(tableName, schema);
        }
        return schema;
    }

    public Transaction newTransaction() {
        Transaction transaction = new Transaction(UUID.randomUUID().toString(), this, true);
        log.info("Started transaction " + transaction.getId());
        return transaction;
    }

    public Transaction resumeTransaction(String txId) {
        Transaction transaction = new Transaction(txId, this, false);
        log.info("Resuming transaction from id " + transaction.getId());
        return transaction;
    }

    public Transaction resumeTransaction(Map<String, AttributeValue> txItem) {
        Transaction transaction = new Transaction(txItem, this);
        log.info("Resuming transaction from item " + transaction.getId());
        return transaction;
    }

    public static boolean isTransactionItem(Map<String, AttributeValue> txItem) {
        return TransactionItem.isTransactionItem(txItem);
    }

    public AppDynamoDBClient getClient() {
        return this.client;
    }

    public DynamoDBMapper getClientMapper() {
        return this.clientMapper;
    }

    protected ThreadLocalDynamoDBFacade getFacadeProxy() {
        return this.facadeProxy;
    }

    public GetItemResult getItem(GetItemRequest request, Transaction.IsolationLevel isolationLevel) {
        return Transaction.getItem(request, isolationLevel, this);
    }

    public String getTransactionTableName() {
        return "transactions".concat("-").concat(this.client.getNameOfDatabase());
    }

    public String getItemImageTableName() {
        return "transactionImages".concat("-").concat(this.client.getNameOfDatabase());
    }

    public void breakLock(String tableName, Map<String, AttributeValue> item, String txId) {
        Transaction.unlockItemUnsafe(this, tableName, item, txId);
    }

    public void verifyOrCreateTransactionTable(AppDynamoDBClient client, long readCapacityUnits, long writeCapacityUnits, Long waitTimeSeconds) throws InterruptedException {
        new TableHelper((AmazonDynamoDB)client).verifyOrCreateTable("transactions".concat("-").concat(client.getNameOfDatabase()), TRANSACTIONS_TABLE_ATTRIBUTES, TRANSACTIONS_TABLE_KEY_SCHEMA, null, new ProvisionedThroughput().withReadCapacityUnits(Long.valueOf(readCapacityUnits)).withWriteCapacityUnits(Long.valueOf(writeCapacityUnits)), waitTimeSeconds);
    }

    public void verifyOrCreateTransactionImagesTable(AppDynamoDBClient client, long readCapacityUnits, long writeCapacityUnits, Long waitTimeSeconds) throws InterruptedException {
        new TableHelper((AmazonDynamoDB)client).verifyOrCreateTable("transactionImages".concat("-").concat(client.getNameOfDatabase()), TRANSACTION_IMAGES_TABLE_ATTRIBUTES, TRANSACTION_IMAGES_TABLE_KEY_SCHEMA, null, new ProvisionedThroughput().withReadCapacityUnits(Long.valueOf(readCapacityUnits)).withWriteCapacityUnits(Long.valueOf(writeCapacityUnits)), waitTimeSeconds);
    }

    public void verifyTransactionTablesExist(AppDynamoDBClient client) {
        String state = new TableHelper((AmazonDynamoDB)client).verifyTableExists("transactions".concat("-").concat(client.getNameOfDatabase()), TRANSACTIONS_TABLE_ATTRIBUTES, TRANSACTIONS_TABLE_KEY_SCHEMA, null);
        if (!"ACTIVE".equals(state)) {
            throw new ResourceInUseException("Table " + "transactions".concat("-").concat(client.getNameOfDatabase()) + " is not ACTIVE");
        }
        state = new TableHelper((AmazonDynamoDB)client).verifyTableExists("transactionImages".concat("-").concat(client.getNameOfDatabase()), TRANSACTION_IMAGES_TABLE_ATTRIBUTES, TRANSACTION_IMAGES_TABLE_KEY_SCHEMA, null);
        if (!"ACTIVE".equals(state)) {
            throw new ResourceInUseException("Table " + "transactionImages".concat("-").concat(client.getNameOfDatabase()) + " is not ACTIVE");
        }
    }

    protected double getCurrentTime() {
        return (double)System.currentTimeMillis() / 1000.0;
    }

    protected AttributeValue getCurrentTimeAttribute() {
        return new AttributeValue().withN(new Double(this.getCurrentTime()).toString());
    }

    static {
        TRANSACTIONS_TABLE_KEY_SCHEMA = Collections.unmodifiableList(Arrays.asList(new KeySchemaElement().withAttributeName(Transaction.AttributeName.TXID.toString()).withKeyType(KeyType.HASH)));
        TRANSACTION_IMAGES_TABLE_KEY_SCHEMA = Collections.unmodifiableList(Arrays.asList(new KeySchemaElement().withAttributeName(Transaction.AttributeName.IMAGE_ID.toString()).withKeyType(KeyType.HASH)));
        List<AttributeDefinition> definition = Arrays.asList(new AttributeDefinition().withAttributeName(Transaction.AttributeName.TXID.toString()).withAttributeType(ScalarAttributeType.S));
        Collections.sort(definition, new AttributeDefinitionComparator());
        TRANSACTIONS_TABLE_ATTRIBUTES = Collections.unmodifiableList(definition);
        definition = Arrays.asList(new AttributeDefinition().withAttributeName(Transaction.AttributeName.IMAGE_ID.toString()).withAttributeType(ScalarAttributeType.S));
        Collections.sort(definition, new AttributeDefinitionComparator());
        TRANSACTION_IMAGES_TABLE_ATTRIBUTES = Collections.unmodifiableList(definition);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AttributeDefinitionComparator
    implements Comparator<AttributeDefinition> {
        private AttributeDefinitionComparator() {
        }

        @Override
        public int compare(AttributeDefinition arg0, AttributeDefinition arg1) {
            if (arg0 == null) {
                return -1;
            }
            if (arg1 == null) {
                return 1;
            }
            int comp = arg0.getAttributeName().compareTo(arg1.getAttributeName());
            if (comp != 0) {
                return comp;
            }
            comp = arg0.getAttributeType().compareTo(arg1.getAttributeType());
            return comp;
        }
    }
}

