/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.dynamo.db.lib.transactions;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.regions.Region;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemResult;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemResult;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.CreateTableResult;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteItemResult;
import com.amazonaws.services.dynamodbv2.model.DeleteTableRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteTableResult;
import com.amazonaws.services.dynamodbv2.model.DescribeLimitsRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeLimitsResult;
import com.amazonaws.services.dynamodbv2.model.DescribeTableRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeTableResult;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemResult;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import com.amazonaws.services.dynamodbv2.model.ListTablesRequest;
import com.amazonaws.services.dynamodbv2.model.ListTablesResult;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.PutItemResult;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.QueryResult;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateItemResult;
import com.amazonaws.services.dynamodbv2.model.UpdateTableRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateTableResult;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadLocalDynamoDBFacade
implements AmazonDynamoDB {
    private final ThreadLocal<AmazonDynamoDB> backend = new ThreadLocal();

    private AmazonDynamoDB getBackend() {
        if (this.backend.get() == null) {
            throw new RuntimeException("No backend to proxy");
        }
        return this.backend.get();
    }

    public void setBackend(AmazonDynamoDB newBackend) {
        this.backend.set(newBackend);
    }

    public BatchGetItemResult batchGetItem(BatchGetItemRequest request) throws AmazonServiceException, AmazonClientException {
        return this.getBackend().batchGetItem(request);
    }

    public BatchWriteItemResult batchWriteItem(BatchWriteItemRequest request) throws AmazonServiceException, AmazonClientException {
        return this.getBackend().batchWriteItem(request);
    }

    public CreateTableResult createTable(CreateTableRequest request) throws AmazonServiceException, AmazonClientException {
        return this.getBackend().createTable(request);
    }

    public DeleteItemResult deleteItem(DeleteItemRequest request) throws AmazonServiceException, AmazonClientException {
        return this.getBackend().deleteItem(request);
    }

    public DeleteTableResult deleteTable(DeleteTableRequest request) throws AmazonServiceException, AmazonClientException {
        return this.getBackend().deleteTable(request);
    }

    public DescribeTableResult describeTable(DescribeTableRequest request) throws AmazonServiceException, AmazonClientException {
        return this.getBackend().describeTable(request);
    }

    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.getBackend().getCachedResponseMetadata(request);
    }

    public GetItemResult getItem(GetItemRequest request) throws AmazonServiceException, AmazonClientException {
        return this.getBackend().getItem(request);
    }

    public ListTablesResult listTables() throws AmazonServiceException, AmazonClientException {
        return this.getBackend().listTables();
    }

    public ListTablesResult listTables(ListTablesRequest request) throws AmazonServiceException, AmazonClientException {
        return this.getBackend().listTables(request);
    }

    public PutItemResult putItem(PutItemRequest request) throws AmazonServiceException, AmazonClientException {
        return this.getBackend().putItem(request);
    }

    public QueryResult query(QueryRequest request) throws AmazonServiceException, AmazonClientException {
        return this.getBackend().query(request);
    }

    public ScanResult scan(ScanRequest request) throws AmazonServiceException, AmazonClientException {
        return this.getBackend().scan(request);
    }

    public void setEndpoint(String request) throws IllegalArgumentException {
        this.getBackend().setEndpoint(request);
    }

    public void setRegion(Region request) throws IllegalArgumentException {
        this.getBackend().setRegion(request);
    }

    public void shutdown() {
        this.getBackend().shutdown();
    }

    public UpdateItemResult updateItem(UpdateItemRequest request) throws AmazonServiceException, AmazonClientException {
        return this.getBackend().updateItem(request);
    }

    public UpdateTableResult updateTable(UpdateTableRequest request) throws AmazonServiceException, AmazonClientException {
        return this.getBackend().updateTable(request);
    }

    public ScanResult scan(String tableName, List<String> attributesToGet) throws AmazonServiceException, AmazonClientException {
        return this.getBackend().scan(tableName, attributesToGet);
    }

    public ScanResult scan(String tableName, Map<String, Condition> scanFilter) throws AmazonServiceException, AmazonClientException {
        return this.getBackend().scan(tableName, scanFilter);
    }

    public ScanResult scan(String tableName, List<String> attributesToGet, Map<String, Condition> scanFilter) throws AmazonServiceException, AmazonClientException {
        return this.getBackend().scan(tableName, attributesToGet, scanFilter);
    }

    public UpdateTableResult updateTable(String tableName, ProvisionedThroughput provisionedThroughput) throws AmazonServiceException, AmazonClientException {
        return this.getBackend().updateTable(tableName, provisionedThroughput);
    }

    public DeleteTableResult deleteTable(String tableName) throws AmazonServiceException, AmazonClientException {
        return this.getBackend().deleteTable(tableName);
    }

    public DescribeLimitsResult describeLimits(DescribeLimitsRequest describeLimitsRequest) {
        return this.getBackend().describeLimits(describeLimitsRequest);
    }

    public BatchWriteItemResult batchWriteItem(Map<String, List<WriteRequest>> requestItems) throws AmazonServiceException, AmazonClientException {
        return this.getBackend().batchWriteItem(requestItems);
    }

    public DescribeTableResult describeTable(String tableName) throws AmazonServiceException, AmazonClientException {
        return this.getBackend().describeTable(tableName);
    }

    public GetItemResult getItem(String tableName, Map<String, AttributeValue> key) throws AmazonServiceException, AmazonClientException {
        return this.getBackend().getItem(tableName, key);
    }

    public GetItemResult getItem(String tableName, Map<String, AttributeValue> key, Boolean consistentRead) throws AmazonServiceException, AmazonClientException {
        return this.getBackend().getItem(tableName, key, consistentRead);
    }

    public DeleteItemResult deleteItem(String tableName, Map<String, AttributeValue> key) throws AmazonServiceException, AmazonClientException {
        return this.getBackend().deleteItem(tableName, key);
    }

    public DeleteItemResult deleteItem(String tableName, Map<String, AttributeValue> key, String returnValues) throws AmazonServiceException, AmazonClientException {
        return this.getBackend().deleteItem(tableName, key, returnValues);
    }

    public CreateTableResult createTable(List<AttributeDefinition> attributeDefinitions, String tableName, List<KeySchemaElement> keySchema, ProvisionedThroughput provisionedThroughput) throws AmazonServiceException, AmazonClientException {
        return this.getBackend().createTable(attributeDefinitions, tableName, keySchema, provisionedThroughput);
    }

    public PutItemResult putItem(String tableName, Map<String, AttributeValue> item) throws AmazonServiceException, AmazonClientException {
        return this.getBackend().putItem(tableName, item);
    }

    public PutItemResult putItem(String tableName, Map<String, AttributeValue> item, String returnValues) throws AmazonServiceException, AmazonClientException {
        return this.getBackend().putItem(tableName, item, returnValues);
    }

    public ListTablesResult listTables(String exclusiveStartTableName) throws AmazonServiceException, AmazonClientException {
        return this.getBackend().listTables(exclusiveStartTableName);
    }

    public ListTablesResult listTables(String exclusiveStartTableName, Integer limit) throws AmazonServiceException, AmazonClientException {
        return this.getBackend().listTables(exclusiveStartTableName, limit);
    }

    public ListTablesResult listTables(Integer limit) throws AmazonServiceException, AmazonClientException {
        return this.getBackend().listTables(limit);
    }

    public UpdateItemResult updateItem(String tableName, Map<String, AttributeValue> key, Map<String, AttributeValueUpdate> attributeUpdates) throws AmazonServiceException, AmazonClientException {
        return this.getBackend().updateItem(tableName, key, attributeUpdates);
    }

    public UpdateItemResult updateItem(String tableName, Map<String, AttributeValue> key, Map<String, AttributeValueUpdate> attributeUpdates, String returnValues) throws AmazonServiceException, AmazonClientException {
        return this.getBackend().updateItem(tableName, key, attributeUpdates, returnValues);
    }

    public BatchGetItemResult batchGetItem(Map<String, KeysAndAttributes> requestItems, String returnConsumedCapacity) throws AmazonServiceException, AmazonClientException {
        return this.getBackend().batchGetItem(requestItems, returnConsumedCapacity);
    }

    public BatchGetItemResult batchGetItem(Map<String, KeysAndAttributes> requestItems) throws AmazonServiceException, AmazonClientException {
        return this.getBackend().batchGetItem(requestItems);
    }
}

