/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.dynamo.db.lib.transactions;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ImmutableAttributeValue {
    private final String n;
    private final String s;
    private final byte[] b;
    private final List<String> ns;
    private final List<String> ss;
    private final List<byte[]> bs;

    public ImmutableAttributeValue(AttributeValue av) {
        this.s = av.getS();
        this.n = av.getN();
        this.b = av.getB() != null ? (byte[])av.getB().array().clone() : null;
        this.ns = av.getNS() != null ? new ArrayList(av.getNS()) : null;
        this.ss = av.getSS() != null ? new ArrayList(av.getSS()) : null;
        ArrayList arrayList = this.bs = av.getBS() != null ? new ArrayList(av.getBS().size()) : null;
        if (av.getBS() != null) {
            for (ByteBuffer buf : av.getBS()) {
                if (buf != null) {
                    this.bs.add((byte[])buf.array().clone());
                    continue;
                }
                this.bs.add(null);
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.b);
        result = 31 * result + (this.bs == null ? 0 : this.bs.hashCode());
        result = 31 * result + (this.n == null ? 0 : this.n.hashCode());
        result = 31 * result + (this.ns == null ? 0 : this.ns.hashCode());
        result = 31 * result + (this.s == null ? 0 : this.s.hashCode());
        result = 31 * result + (this.ss == null ? 0 : this.ss.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableAttributeValue other = (ImmutableAttributeValue)obj;
        if (!Arrays.equals(this.b, other.b)) {
            return false;
        }
        if (this.bs == null) {
            if (other.bs != null) {
                return false;
            }
        } else if (!this.bs.equals(other.bs)) {
            if (other.bs == null) {
                return false;
            }
            if (this.bs.size() != other.bs.size()) {
                return false;
            }
            for (int i = 0; i < this.bs.size(); ++i) {
                if (Arrays.equals(this.bs.get(i), other.bs.get(i))) continue;
                return false;
            }
            return true;
        }
        if (this.n == null ? other.n != null : !this.n.equals(other.n)) {
            return false;
        }
        if (this.ns == null ? other.ns != null : !this.ns.equals(other.ns)) {
            return false;
        }
        if (this.s == null ? other.s != null : !this.s.equals(other.s)) {
            return false;
        }
        return !(this.ss == null ? other.ss != null : !this.ss.equals(other.ss));
    }
}

