/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.dynamo.db.lib.manage.impl;

import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.QueryResult;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import com.google.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.quadcom.dynamo.db.lib.manage.AppDynamoDBClient;
import ru.quadcom.dynamo.db.lib.manage.interfaces.IQueryScanDynamoDBService;

public class QueryScanDynamoDBService
implements IQueryScanDynamoDBService {
    private static final Logger logger = LoggerFactory.getLogger(QueryScanDynamoDBService.class);
    private final AppDynamoDBClient dbClient;

    @Inject
    public QueryScanDynamoDBService(AppDynamoDBClient dbClient) {
        this.dbClient = dbClient;
    }

    public QueryResult query(QueryRequest queryRequest) {
        String finalTableName = queryRequest.getTableName().concat("-").concat(this.dbClient.getNameOfDatabase());
        logger.info("query : from table : {}", (Object)finalTableName);
        queryRequest = queryRequest.withTableName(finalTableName).withConsistentRead(Boolean.valueOf(false));
        return this.dbClient.query(queryRequest);
    }

    public QueryResult queryWithStrongConsistency(QueryRequest queryRequest) {
        String finalTableName = queryRequest.getTableName().concat("-").concat(this.dbClient.getNameOfDatabase());
        logger.info("queryWithStrongConsistency : from table : {}", (Object)finalTableName);
        queryRequest = queryRequest.withTableName(finalTableName).withConsistentRead(Boolean.valueOf(true));
        return this.dbClient.query(queryRequest);
    }

    public ScanResult scan(ScanRequest scanRequest) {
        String finalTableName = scanRequest.getTableName().concat("-").concat(this.dbClient.getNameOfDatabase());
        logger.info("scan : from table : {}", (Object)finalTableName);
        scanRequest = scanRequest.withTableName(finalTableName);
        return this.dbClient.scan(scanRequest);
    }
}

