/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.dynamo.db.lib.exceptions;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.util.Map;
import ru.quadcom.dynamo.db.lib.exceptions.TransactionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemNotLockedException
extends TransactionException {
    private final String txId;
    private final String lockOwnerTxId;
    private final String tableName;
    private final Map<String, AttributeValue> item;

    public ItemNotLockedException(String txId, String lockTxId, String tableName, Map<String, AttributeValue> item) {
        this(txId, lockTxId, tableName, item, null);
    }

    public ItemNotLockedException(String txId, String lockOwnerTxId, String tableName, Map<String, AttributeValue> item, Throwable t) {
        super(txId, "Item is not locked by our transaction, is locked by " + lockOwnerTxId + " for table " + tableName + ", item: " + item);
        this.txId = txId;
        this.lockOwnerTxId = lockOwnerTxId;
        this.tableName = tableName;
        this.item = item;
    }

    @Override
    public String getTxId() {
        return this.txId;
    }

    public String getLockOwnerTxId() {
        return this.lockOwnerTxId;
    }

    public Map<String, AttributeValue> getItem() {
        return this.item;
    }

    public String getTableName() {
        return this.tableName;
    }
}

